/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.internal.storage.file;

import com.netflix.nebula.jgit.attributes.AttributesNode;
import com.netflix.nebula.jgit.internal.storage.file.FileRepository;
import com.netflix.nebula.jgit.lib.CoreConfig;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.util.FS;
import java.io.File;
import java.io.IOException;

public class GlobalAttributesNode
extends AttributesNode {
    final Repository repository;

    public GlobalAttributesNode(Repository repository) {
        this.repository = repository;
    }

    public AttributesNode load() throws IOException {
        AttributesNode r = new AttributesNode();
        FS fs = this.repository.getFS();
        String path = this.repository.getConfig().get(CoreConfig.KEY).getAttributesFile();
        if (path != null) {
            File attributesFile = path.startsWith("~/") ? fs.resolve(fs.userHome(), path.substring(2)) : fs.resolve(null, path);
            FileRepository.AttributesNodeProviderImpl.loadRulesFromFile(r, attributesFile);
        }
        return r.getRules().isEmpty() ? null : r;
    }
}

