/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.internal.storage.file;

import com.netflix.nebula.jgit.internal.storage.file.LocalObjectRepresentation;
import com.netflix.nebula.jgit.internal.storage.file.ObjectDirectory;
import com.netflix.nebula.jgit.internal.storage.file.PackFile;
import com.netflix.nebula.jgit.internal.storage.file.WindowCursor;
import com.netflix.nebula.jgit.internal.storage.pack.CachedPack;
import com.netflix.nebula.jgit.internal.storage.pack.ObjectToPack;
import com.netflix.nebula.jgit.internal.storage.pack.PackOutputStream;
import com.netflix.nebula.jgit.internal.storage.pack.StoredObjectRepresentation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

class LocalCachedPack
extends CachedPack {
    private final ObjectDirectory odb;
    private final String[] packNames;
    private PackFile[] packs;

    LocalCachedPack(ObjectDirectory odb, List<String> packNames) {
        this.odb = odb;
        this.packNames = packNames.toArray(new String[packNames.size()]);
    }

    LocalCachedPack(List<PackFile> packs) {
        this.odb = null;
        this.packNames = null;
        this.packs = packs.toArray(new PackFile[packs.size()]);
    }

    @Override
    public long getObjectCount() throws IOException {
        long cnt = 0L;
        for (PackFile pack : this.getPacks()) {
            cnt += pack.getObjectCount();
        }
        return cnt;
    }

    void copyAsIs(PackOutputStream out, WindowCursor wc) throws IOException {
        for (PackFile pack : this.getPacks()) {
            pack.copyPackAsIs(out, wc);
        }
    }

    @Override
    public boolean hasObject(ObjectToPack obj, StoredObjectRepresentation rep) {
        try {
            LocalObjectRepresentation local = (LocalObjectRepresentation)rep;
            for (PackFile pack : this.getPacks()) {
                if (local.pack != pack) continue;
                return true;
            }
            return false;
        }
        catch (FileNotFoundException packGone) {
            return false;
        }
    }

    private PackFile[] getPacks() throws FileNotFoundException {
        if (this.packs == null) {
            PackFile[] p = new PackFile[this.packNames.length];
            for (int i = 0; i < this.packNames.length; ++i) {
                p[i] = this.getPackFile(this.packNames[i]);
            }
            this.packs = p;
        }
        return this.packs;
    }

    private PackFile getPackFile(String packName) throws FileNotFoundException {
        for (PackFile pack : this.odb.getPacks()) {
            if (!packName.equals(pack.getPackName())) continue;
            return pack;
        }
        throw new FileNotFoundException(this.getPackFilePath(packName));
    }

    private String getPackFilePath(String packName) {
        File packDir = new File(this.odb.getDirectory(), "pack");
        return new File(packDir, "pack-" + packName + ".pack").getPath();
    }
}

