/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.internal.storage.file;

import com.netflix.nebula.jgit.internal.storage.file.LockFile;
import com.netflix.nebula.jgit.internal.storage.file.RefDirectory;
import com.netflix.nebula.jgit.internal.storage.file.WriteConfig;
import com.netflix.nebula.jgit.lib.Constants;
import com.netflix.nebula.jgit.lib.Ref;
import com.netflix.nebula.jgit.lib.RefUpdate;
import com.netflix.nebula.jgit.lib.Repository;
import java.io.IOException;

class RefDirectoryUpdate
extends RefUpdate {
    private final RefDirectory database;
    private LockFile lock;

    RefDirectoryUpdate(RefDirectory r, Ref ref) {
        super(ref);
        this.database = r;
    }

    @Override
    protected RefDirectory getRefDatabase() {
        return this.database;
    }

    @Override
    protected Repository getRepository() {
        return this.database.getRepository();
    }

    @Override
    protected boolean tryLock(boolean deref) throws IOException {
        Ref dst = this.getRef();
        if (deref) {
            dst = dst.getLeaf();
        }
        String name = dst.getName();
        this.lock = new LockFile(this.database.fileFor(name));
        if (this.lock.lock()) {
            dst = this.database.getRef(name);
            this.setOldObjectId(dst != null ? dst.getObjectId() : null);
            return true;
        }
        return false;
    }

    @Override
    protected void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
            this.lock = null;
        }
    }

    @Override
    protected RefUpdate.Result doUpdate(RefUpdate.Result status) throws IOException {
        WriteConfig wc = this.database.getRepository().getConfig().get(WriteConfig.KEY);
        this.lock.setFSync(wc.getFSyncRefFiles());
        this.lock.setNeedStatInformation(true);
        this.lock.write(this.getNewObjectId());
        String msg = this.getRefLogMessage();
        if (msg != null) {
            String strResult;
            if (this.isRefLogIncludingResult() && (strResult = this.toResultString(status)) != null) {
                msg = msg.length() > 0 ? msg + ": " + strResult : strResult;
            }
            this.database.log(this, msg, true);
        }
        if (!this.lock.commit()) {
            return RefUpdate.Result.LOCK_FAILURE;
        }
        this.database.stored(this, this.lock.getCommitSnapshot());
        return status;
    }

    private String toResultString(RefUpdate.Result status) {
        switch (status) {
            case FORCED: {
                return "forced-update";
            }
            case FAST_FORWARD: {
                return "fast forward";
            }
            case NEW: {
                return "created";
            }
        }
        return null;
    }

    @Override
    protected RefUpdate.Result doDelete(RefUpdate.Result status) throws IOException {
        if (this.getRef().getLeaf().getStorage() != Ref.Storage.NEW) {
            this.database.delete(this);
        }
        return status;
    }

    @Override
    protected RefUpdate.Result doLink(String target) throws IOException {
        WriteConfig wc = this.database.getRepository().getConfig().get(WriteConfig.KEY);
        this.lock.setFSync(wc.getFSyncRefFiles());
        this.lock.setNeedStatInformation(true);
        this.lock.write(Constants.encode("ref: " + target + '\n'));
        String msg = this.getRefLogMessage();
        if (msg != null) {
            this.database.log(this, msg, false);
        }
        if (!this.lock.commit()) {
            return RefUpdate.Result.LOCK_FAILURE;
        }
        this.database.storedSymbolicRef(this, this.lock.getCommitSnapshot(), target);
        if (this.getRef().getStorage() == Ref.Storage.NEW) {
            return RefUpdate.Result.NEW;
        }
        return RefUpdate.Result.FORCED;
    }
}

