/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.internal.storage.pack;

import com.netflix.nebula.jgit.internal.JGitText;
import com.netflix.nebula.jgit.util.QuotedString;
import com.netflix.nebula.jgit.util.RawParseUtils;

public class BinaryDelta {
    public static long getBaseSize(byte[] delta) {
        int c;
        int p = 0;
        long baseLen = 0L;
        int shift = 0;
        do {
            c = delta[p++] & 0xFF;
            baseLen |= (long)(c & 0x7F) << shift;
            shift += 7;
        } while ((c & 0x80) != 0);
        return baseLen;
    }

    public static long getResultSize(byte[] delta) {
        int c;
        int p = 0;
        while (((c = delta[p++] & 0xFF) & 0x80) != 0) {
        }
        long resLen = 0L;
        int shift = 0;
        do {
            c = delta[p++] & 0xFF;
            resLen |= (long)(c & 0x7F) << shift;
            shift += 7;
        } while ((c & 0x80) != 0);
        return resLen;
    }

    public static final byte[] apply(byte[] base, byte[] delta) {
        return BinaryDelta.apply(base, delta, null);
    }

    public static final byte[] apply(byte[] base, byte[] delta, byte[] result) {
        int c;
        int deltaPtr = 0;
        int baseLen = 0;
        int shift = 0;
        do {
            c = delta[deltaPtr++] & 0xFF;
            baseLen = (int)((long)baseLen | (long)(c & 0x7F) << shift);
            shift += 7;
        } while ((c & 0x80) != 0);
        if (base.length != baseLen) {
            throw new IllegalArgumentException(JGitText.get().baseLengthIncorrect);
        }
        int resLen = 0;
        shift = 0;
        do {
            c = delta[deltaPtr++] & 0xFF;
            resLen = (int)((long)resLen | (long)(c & 0x7F) << shift);
            shift += 7;
        } while ((c & 0x80) != 0);
        if (result == null) {
            result = new byte[resLen];
        } else if (result.length != resLen) {
            throw new IllegalArgumentException(JGitText.get().resultLengthIncorrect);
        }
        int resultPtr = 0;
        while (deltaPtr < delta.length) {
            int cmd;
            if (((cmd = delta[deltaPtr++] & 0xFF) & 0x80) != 0) {
                int copyOffset = 0;
                if ((cmd & 1) != 0) {
                    copyOffset = delta[deltaPtr++] & 0xFF;
                }
                if ((cmd & 2) != 0) {
                    copyOffset |= (delta[deltaPtr++] & 0xFF) << 8;
                }
                if ((cmd & 4) != 0) {
                    copyOffset |= (delta[deltaPtr++] & 0xFF) << 16;
                }
                if ((cmd & 8) != 0) {
                    copyOffset |= (delta[deltaPtr++] & 0xFF) << 24;
                }
                int copySize = 0;
                if ((cmd & 0x10) != 0) {
                    copySize = delta[deltaPtr++] & 0xFF;
                }
                if ((cmd & 0x20) != 0) {
                    copySize |= (delta[deltaPtr++] & 0xFF) << 8;
                }
                if ((cmd & 0x40) != 0) {
                    copySize |= (delta[deltaPtr++] & 0xFF) << 16;
                }
                if (copySize == 0) {
                    copySize = 65536;
                }
                System.arraycopy(base, copyOffset, result, resultPtr, copySize);
                resultPtr += copySize;
                continue;
            }
            if (cmd != 0) {
                System.arraycopy(delta, deltaPtr, result, resultPtr, cmd);
                deltaPtr += cmd;
                resultPtr += cmd;
                continue;
            }
            throw new IllegalArgumentException(JGitText.get().unsupportedCommand0);
        }
        return result;
    }

    public static String format(byte[] delta) {
        return BinaryDelta.format(delta, true);
    }

    public static String format(byte[] delta, boolean includeHeader) {
        int c;
        StringBuilder r = new StringBuilder();
        int deltaPtr = 0;
        long baseLen = 0L;
        int shift = 0;
        do {
            c = delta[deltaPtr++] & 0xFF;
            baseLen |= (long)(c & 0x7F) << shift;
            shift += 7;
        } while ((c & 0x80) != 0);
        long resLen = 0L;
        shift = 0;
        do {
            c = delta[deltaPtr++] & 0xFF;
            resLen |= (long)(c & 0x7F) << shift;
            shift += 7;
        } while ((c & 0x80) != 0);
        if (includeHeader) {
            r.append("DELTA( BASE=");
            r.append(baseLen);
            r.append(" RESULT=");
            r.append(resLen);
            r.append(" )\n");
        }
        while (deltaPtr < delta.length) {
            int cmd;
            if (((cmd = delta[deltaPtr++] & 0xFF) & 0x80) != 0) {
                int copyOffset = 0;
                if ((cmd & 1) != 0) {
                    copyOffset = delta[deltaPtr++] & 0xFF;
                }
                if ((cmd & 2) != 0) {
                    copyOffset |= (delta[deltaPtr++] & 0xFF) << 8;
                }
                if ((cmd & 4) != 0) {
                    copyOffset |= (delta[deltaPtr++] & 0xFF) << 16;
                }
                if ((cmd & 8) != 0) {
                    copyOffset |= (delta[deltaPtr++] & 0xFF) << 24;
                }
                int copySize = 0;
                if ((cmd & 0x10) != 0) {
                    copySize = delta[deltaPtr++] & 0xFF;
                }
                if ((cmd & 0x20) != 0) {
                    copySize |= (delta[deltaPtr++] & 0xFF) << 8;
                }
                if ((cmd & 0x40) != 0) {
                    copySize |= (delta[deltaPtr++] & 0xFF) << 16;
                }
                if (copySize == 0) {
                    copySize = 65536;
                }
                r.append("  COPY  (");
                r.append(copyOffset);
                r.append(", ");
                r.append(copySize);
                r.append(")\n");
                continue;
            }
            if (cmd != 0) {
                r.append("  INSERT(");
                r.append(QuotedString.GIT_PATH.quote(RawParseUtils.decode(delta, deltaPtr, deltaPtr + cmd)));
                r.append(")\n");
                deltaPtr += cmd;
                continue;
            }
            throw new IllegalArgumentException(JGitText.get().unsupportedCommand0);
        }
        return r.toString();
    }
}

