/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.lib;

import com.netflix.nebula.jgit.lib.AnyObjectId;
import com.netflix.nebula.jgit.lib.Constants;
import com.netflix.nebula.jgit.lib.ObjectId;
import com.netflix.nebula.jgit.lib.PersonIdent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;

public class CommitBuilder {
    private static final ObjectId[] EMPTY_OBJECTID_LIST = new ObjectId[0];
    private static final byte[] htree = Constants.encodeASCII("tree");
    private static final byte[] hparent = Constants.encodeASCII("parent");
    private static final byte[] hauthor = Constants.encodeASCII("author");
    private static final byte[] hcommitter = Constants.encodeASCII("committer");
    private static final byte[] hencoding = Constants.encodeASCII("encoding");
    private ObjectId treeId;
    private ObjectId[] parentIds = EMPTY_OBJECTID_LIST;
    private PersonIdent author;
    private PersonIdent committer;
    private String message;
    private Charset encoding = Constants.CHARSET;

    public ObjectId getTreeId() {
        return this.treeId;
    }

    public void setTreeId(AnyObjectId id) {
        this.treeId = id.copy();
    }

    public PersonIdent getAuthor() {
        return this.author;
    }

    public void setAuthor(PersonIdent newAuthor) {
        this.author = newAuthor;
    }

    public PersonIdent getCommitter() {
        return this.committer;
    }

    public void setCommitter(PersonIdent newCommitter) {
        this.committer = newCommitter;
    }

    public ObjectId[] getParentIds() {
        return this.parentIds;
    }

    public void setParentId(AnyObjectId newParent) {
        this.parentIds = new ObjectId[]{newParent.copy()};
    }

    public void setParentIds(AnyObjectId parent1, AnyObjectId parent2) {
        this.parentIds = new ObjectId[]{parent1.copy(), parent2.copy()};
    }

    public void setParentIds(ObjectId ... newParents) {
        this.parentIds = new ObjectId[newParents.length];
        for (int i = 0; i < newParents.length; ++i) {
            this.parentIds[i] = newParents[i].copy();
        }
    }

    public void setParentIds(List<? extends AnyObjectId> newParents) {
        this.parentIds = new ObjectId[newParents.size()];
        for (int i = 0; i < newParents.size(); ++i) {
            this.parentIds[i] = newParents.get(i).copy();
        }
    }

    public void addParentId(AnyObjectId additionalParent) {
        if (this.parentIds.length == 0) {
            this.setParentId(additionalParent);
        } else {
            ObjectId[] newParents = new ObjectId[this.parentIds.length + 1];
            System.arraycopy(this.parentIds, 0, newParents, 0, this.parentIds.length);
            newParents[this.parentIds.length] = additionalParent.copy();
            this.parentIds = newParents;
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String newMessage) {
        this.message = newMessage;
    }

    public void setEncoding(String encodingName) {
        this.encoding = Charset.forName(encodingName);
    }

    public void setEncoding(Charset enc) {
        this.encoding = enc;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public byte[] build() throws UnsupportedEncodingException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, this.getEncoding());
        try {
            os.write(htree);
            os.write(32);
            this.getTreeId().copyTo(os);
            os.write(10);
            for (ObjectId p : this.getParentIds()) {
                os.write(hparent);
                os.write(32);
                p.copyTo(os);
                os.write(10);
            }
            os.write(hauthor);
            os.write(32);
            w.write(this.getAuthor().toExternalString());
            w.flush();
            os.write(10);
            os.write(hcommitter);
            os.write(32);
            w.write(this.getCommitter().toExternalString());
            w.flush();
            os.write(10);
            if (this.getEncoding() != Constants.CHARSET) {
                os.write(hencoding);
                os.write(32);
                os.write(Constants.encodeASCII(this.getEncoding().name()));
                os.write(10);
            }
            os.write(10);
            if (this.getMessage() != null) {
                w.write(this.getMessage());
                w.flush();
            }
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
        return os.toByteArray();
    }

    public byte[] toByteArray() throws UnsupportedEncodingException {
        return this.build();
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Commit");
        r.append("={\n");
        r.append("tree ");
        r.append(this.treeId != null ? this.treeId.name() : "NOT_SET");
        r.append("\n");
        for (ObjectId p : this.parentIds) {
            r.append("parent ");
            r.append(p.name());
            r.append("\n");
        }
        r.append("author ");
        r.append(this.author != null ? this.author.toString() : "NOT_SET");
        r.append("\n");
        r.append("committer ");
        r.append(this.committer != null ? this.committer.toString() : "NOT_SET");
        r.append("\n");
        if (this.encoding != null && this.encoding != Constants.CHARSET) {
            r.append("encoding ");
            r.append(this.encoding.name());
            r.append("\n");
        }
        r.append("\n");
        r.append(this.message != null ? this.message : "");
        r.append("}");
        return r.toString();
    }
}

