/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.lib;

import java.util.zip.Inflater;

public class InflaterCache {
    private static final int SZ = 4;
    private static final Inflater[] inflaterCache = new Inflater[4];
    private static int openInflaterCount;

    public static Inflater get() {
        Inflater r = InflaterCache.getImpl();
        return r != null ? r : new Inflater(false);
    }

    private static synchronized Inflater getImpl() {
        if (openInflaterCount > 0) {
            Inflater r = inflaterCache[--openInflaterCount];
            InflaterCache.inflaterCache[InflaterCache.openInflaterCount] = null;
            return r;
        }
        return null;
    }

    public static void release(Inflater i) {
        if (i != null) {
            i.reset();
            if (InflaterCache.releaseImpl(i)) {
                i.end();
            }
        }
    }

    private static synchronized boolean releaseImpl(Inflater i) {
        if (openInflaterCount < 4) {
            InflaterCache.inflaterCache[InflaterCache.openInflaterCount++] = i;
            return false;
        }
        return true;
    }

    private InflaterCache() {
        throw new UnsupportedOperationException();
    }
}

