/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.lib;

import com.netflix.nebula.jgit.errors.IncorrectObjectTypeException;
import com.netflix.nebula.jgit.errors.MissingObjectException;
import com.netflix.nebula.jgit.lib.AnyObjectId;
import com.netflix.nebula.jgit.lib.ObjectInserter;
import com.netflix.nebula.jgit.lib.ObjectLoader;
import com.netflix.nebula.jgit.lib.ObjectReader;
import java.io.IOException;

public abstract class ObjectDatabase {
    protected ObjectDatabase() {
    }

    public boolean exists() {
        return true;
    }

    public void create() throws IOException {
    }

    public abstract ObjectInserter newInserter();

    public abstract ObjectReader newReader();

    public abstract void close();

    public boolean has(AnyObjectId objectId) throws IOException {
        try (ObjectReader or = this.newReader();){
            boolean bl = or.has(objectId);
            return bl;
        }
    }

    public ObjectLoader open(AnyObjectId objectId) throws IOException {
        return this.open(objectId, -1);
    }

    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        try (ObjectReader or = this.newReader();){
            ObjectLoader objectLoader = or.open(objectId, typeHint);
            return objectLoader;
        }
    }

    public ObjectDatabase newCachedDatabase() {
        return this;
    }
}

