/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.notes;

import com.netflix.nebula.jgit.internal.JGitText;
import com.netflix.nebula.jgit.notes.NonNoteEntry;
import com.netflix.nebula.jgit.notes.Note;
import java.io.IOException;
import java.text.MessageFormat;

public class NotesMergeConflictException
extends IOException {
    private static final long serialVersionUID = 1L;

    public NotesMergeConflictException(Note base, Note ours, Note theirs) {
        super(MessageFormat.format(JGitText.get().mergeConflictOnNotes, NotesMergeConflictException.noteOn(base, ours, theirs), NotesMergeConflictException.noteData(base), NotesMergeConflictException.noteData(ours), NotesMergeConflictException.noteData(theirs)));
    }

    public NotesMergeConflictException(NonNoteEntry base, NonNoteEntry ours, NonNoteEntry theirs) {
        super(MessageFormat.format(JGitText.get().mergeConflictOnNonNoteEntries, NotesMergeConflictException.name(base), NotesMergeConflictException.name(ours), NotesMergeConflictException.name(theirs)));
    }

    private static String noteOn(Note base, Note ours, Note theirs) {
        if (base != null) {
            return base.name();
        }
        if (ours != null) {
            return ours.name();
        }
        return theirs.name();
    }

    private static String noteData(Note n) {
        if (n != null) {
            return n.getData().name();
        }
        return "";
    }

    private static String name(NonNoteEntry e) {
        return e != null ? e.name() : "";
    }
}

