/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.revwalk;

import com.netflix.nebula.jgit.errors.IncorrectObjectTypeException;
import com.netflix.nebula.jgit.errors.MissingObjectException;
import com.netflix.nebula.jgit.errors.StopWalkException;
import com.netflix.nebula.jgit.lib.ObjectId;
import com.netflix.nebula.jgit.revwalk.DateRevQueue;
import com.netflix.nebula.jgit.revwalk.Generator;
import com.netflix.nebula.jgit.revwalk.RevCommit;
import com.netflix.nebula.jgit.revwalk.RevWalk;
import com.netflix.nebula.jgit.revwalk.filter.RevFilter;
import java.io.IOException;

class PendingGenerator
extends Generator {
    private static final int PARSED = 1;
    private static final int SEEN = 2;
    private static final int UNINTERESTING = 4;
    static final int OVER_SCAN = 6;
    private static final RevCommit INIT_LAST = new RevCommit(ObjectId.zeroId());
    private final RevWalk walker;
    private final DateRevQueue pending;
    private final RevFilter filter;
    private final int output;
    private RevCommit last = INIT_LAST;
    private int overScan = 6;
    boolean canDispose;

    PendingGenerator(RevWalk w, DateRevQueue p, RevFilter f, int out) {
        this.walker = w;
        this.pending = p;
        this.filter = f;
        this.output = out;
        this.canDispose = true;
    }

    @Override
    int outputType() {
        return this.output | 1;
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        try {
            while (true) {
                boolean produce;
                RevCommit c;
                if ((c = this.pending.next()) == null) {
                    return null;
                }
                if ((c.flags & 4) != 0) {
                    produce = false;
                } else {
                    if (this.filter.requiresCommitBody()) {
                        c.parseBody(this.walker);
                    }
                    produce = this.filter.include(this.walker, c);
                }
                for (RevCommit p : c.parents) {
                    if ((p.flags & 2) != 0) continue;
                    if ((p.flags & 1) == 0) {
                        p.parseHeaders(this.walker);
                    }
                    p.flags |= 2;
                    this.pending.add(p);
                }
                this.walker.carryFlagsImpl(c);
                if ((c.flags & 4) != 0) {
                    if (this.pending.everbodyHasFlag(4)) {
                        RevCommit n = this.pending.peek();
                        if (n != null && n.commitTime >= this.last.commitTime) {
                            this.overScan = 6;
                        } else if (--this.overScan == 0) {
                            throw StopWalkException.INSTANCE;
                        }
                    } else {
                        this.overScan = 6;
                    }
                    if (!this.canDispose) continue;
                    c.disposeBody();
                    continue;
                }
                if (produce) {
                    this.last = c;
                    return this.last;
                }
                if (!this.canDispose) continue;
                c.disposeBody();
            }
        }
        catch (StopWalkException swe) {
            this.pending.clear();
            return null;
        }
    }

    static {
        PendingGenerator.INIT_LAST.commitTime = Integer.MAX_VALUE;
    }
}

