/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.transport;

import com.netflix.nebula.jgit.internal.JGitText;
import com.netflix.nebula.jgit.internal.storage.pack.PackWriter;
import com.netflix.nebula.jgit.lib.AnyObjectId;
import com.netflix.nebula.jgit.lib.Constants;
import com.netflix.nebula.jgit.lib.ObjectId;
import com.netflix.nebula.jgit.lib.ProgressMonitor;
import com.netflix.nebula.jgit.lib.Ref;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.revwalk.RevCommit;
import com.netflix.nebula.jgit.storage.pack.PackConfig;
import com.netflix.nebula.jgit.transport.ObjectCountCallback;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class BundleWriter {
    private final Repository db;
    private final Map<String, ObjectId> include;
    private final Set<RevCommit> assume;
    private final Set<ObjectId> tagTargets;
    private PackConfig packConfig;
    private ObjectCountCallback callback;

    public BundleWriter(Repository repo) {
        this.db = repo;
        this.include = new TreeMap<String, ObjectId>();
        this.assume = new HashSet<RevCommit>();
        this.tagTargets = new HashSet<ObjectId>();
    }

    public void setPackConfig(PackConfig pc) {
        this.packConfig = pc;
    }

    public void include(String name, AnyObjectId id) {
        boolean validRefName;
        boolean bl = validRefName = Repository.isValidRefName(name) || "HEAD".equals(name);
        if (!validRefName) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidRefName, name));
        }
        if (this.include.containsKey(name)) {
            throw new IllegalStateException(JGitText.get().duplicateRef + name);
        }
        this.include.put(name, id.toObjectId());
    }

    public void include(Ref r) {
        this.include(r.getName(), r.getObjectId());
        if (r.getPeeledObjectId() != null) {
            this.tagTargets.add(r.getPeeledObjectId());
        } else if (r.getObjectId() != null && r.getName().startsWith("refs/heads/")) {
            this.tagTargets.add(r.getObjectId());
        }
    }

    public void assume(RevCommit c) {
        if (c != null) {
            this.assume.add(c);
        }
    }

    public void writeBundle(ProgressMonitor monitor, OutputStream os) throws IOException {
        PackConfig pc = this.packConfig;
        if (pc == null) {
            pc = new PackConfig(this.db);
        }
        try (PackWriter packWriter = new PackWriter(pc, this.db.newObjectReader());){
            packWriter.setObjectCountCallback(this.callback);
            HashSet<ObjectId> inc = new HashSet<ObjectId>();
            HashSet<ObjectId> exc = new HashSet<ObjectId>();
            inc.addAll(this.include.values());
            for (RevCommit r : this.assume) {
                exc.add(r.getId());
            }
            packWriter.setIndexDisabled(true);
            packWriter.setDeltaBaseAsOffset(true);
            packWriter.setThin(exc.size() > 0);
            packWriter.setReuseValidatingObjects(false);
            if (exc.size() == 0) {
                packWriter.setTagTargets(this.tagTargets);
            }
            packWriter.preparePack(monitor, inc, exc);
            OutputStreamWriter w = new OutputStreamWriter(os, Constants.CHARSET);
            w.write("# v2 git bundle");
            ((Writer)w).write(10);
            char[] tmp = new char[40];
            for (RevCommit revCommit : this.assume) {
                ((Writer)w).write(45);
                revCommit.copyTo(tmp, w);
                if (revCommit.getRawBuffer() != null) {
                    ((Writer)w).write(32);
                    w.write(revCommit.getShortMessage());
                }
                ((Writer)w).write(10);
            }
            for (Map.Entry entry : this.include.entrySet()) {
                ((ObjectId)entry.getValue()).copyTo(tmp, w);
                ((Writer)w).write(32);
                w.write((String)entry.getKey());
                ((Writer)w).write(10);
            }
            ((Writer)w).write(10);
            ((Writer)w).flush();
            packWriter.writePack(monitor, monitor, os);
        }
    }

    public BundleWriter setObjectCountCallback(ObjectCountCallback callback) {
        this.callback = callback;
        return this;
    }
}

