/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.transport;

import com.netflix.nebula.jgit.errors.TransportException;
import com.netflix.nebula.jgit.internal.JGitText;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.transport.BasePackFetchConnection;
import com.netflix.nebula.jgit.transport.PackTransport;
import com.netflix.nebula.jgit.transport.UploadPack;
import com.netflix.nebula.jgit.transport.resolver.ServiceNotAuthorizedException;
import com.netflix.nebula.jgit.transport.resolver.ServiceNotEnabledException;
import com.netflix.nebula.jgit.transport.resolver.UploadPackFactory;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

class InternalFetchConnection<C>
extends BasePackFetchConnection {
    private Thread worker;

    public InternalFetchConnection(PackTransport transport, final UploadPackFactory<C> uploadPackFactory, final C req, final Repository remote) throws TransportException {
        super(transport);
        PipedOutputStream out_w;
        PipedInputStream out_r;
        PipedOutputStream in_w;
        PipedInputStream in_r;
        try {
            in_r = new PipedInputStream();
            in_w = new PipedOutputStream(in_r);
            out_r = new PipedInputStream(){
                {
                    this.buffer = new byte[2952];
                }
            };
            out_w = new PipedOutputStream(out_r);
        }
        catch (IOException err) {
            remote.close();
            throw new TransportException(this.uri, JGitText.get().cannotConnectPipes, err);
        }
        this.worker = new Thread("JGit-Upload-Pack"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    UploadPack rp = uploadPackFactory.create(req, remote);
                    rp.upload(out_r, in_w, null);
                }
                catch (ServiceNotEnabledException rp) {
                }
                catch (ServiceNotAuthorizedException rp) {
                }
                catch (IOException err) {
                    err.printStackTrace();
                }
                catch (RuntimeException err) {
                    err.printStackTrace();
                }
                finally {
                    try {
                        out_r.close();
                    }
                    catch (IOException err) {}
                    try {
                        in_w.close();
                    }
                    catch (IOException err) {}
                    remote.close();
                }
            }
        };
        this.worker.start();
        this.init(in_r, out_w);
        this.readAdvertisedRefs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        try {
            if (this.worker != null) {
                this.worker.join();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.worker = null;
        }
    }
}

