/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.transport;

import com.netflix.nebula.jgit.errors.TransportException;
import com.netflix.nebula.jgit.internal.JGitText;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.transport.BasePackPushConnection;
import com.netflix.nebula.jgit.transport.PackTransport;
import com.netflix.nebula.jgit.transport.ReceivePack;
import com.netflix.nebula.jgit.transport.resolver.ReceivePackFactory;
import com.netflix.nebula.jgit.transport.resolver.ServiceNotAuthorizedException;
import com.netflix.nebula.jgit.transport.resolver.ServiceNotEnabledException;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

class InternalPushConnection<C>
extends BasePackPushConnection {
    private Thread worker;

    public InternalPushConnection(PackTransport transport, final ReceivePackFactory<C> receivePackFactory, final C req, final Repository remote) throws TransportException {
        super(transport);
        PipedOutputStream out_w;
        PipedInputStream out_r;
        PipedOutputStream in_w;
        PipedInputStream in_r;
        try {
            in_r = new PipedInputStream();
            in_w = new PipedOutputStream(in_r);
            out_r = new PipedInputStream();
            out_w = new PipedOutputStream(out_r);
        }
        catch (IOException err) {
            remote.close();
            throw new TransportException(this.uri, JGitText.get().cannotConnectPipes, err);
        }
        this.worker = new Thread("JGit-Receive-Pack"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ReceivePack rp = receivePackFactory.create(req, remote);
                    rp.receive(out_r, in_w, System.err);
                }
                catch (ServiceNotEnabledException serviceNotEnabledException) {
                }
                catch (ServiceNotAuthorizedException serviceNotAuthorizedException) {
                }
                catch (IOException iOException) {
                }
                catch (RuntimeException runtimeException) {
                }
                finally {
                    try {
                        out_r.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        in_w.close();
                    }
                    catch (IOException iOException) {}
                    remote.close();
                }
            }
        };
        this.worker.start();
        this.init(in_r, out_w);
        this.readAdvertisedRefs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        if (this.worker != null) {
            try {
                this.worker.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.worker = null;
            }
        }
    }
}

