/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.transport;

import com.netflix.nebula.jgit.errors.NotSupportedException;
import com.netflix.nebula.jgit.errors.TransportException;
import com.netflix.nebula.jgit.internal.JGitText;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.transport.BundleFetchConnection;
import com.netflix.nebula.jgit.transport.FetchConnection;
import com.netflix.nebula.jgit.transport.PushConnection;
import com.netflix.nebula.jgit.transport.Transport;
import com.netflix.nebula.jgit.transport.TransportBundle;
import com.netflix.nebula.jgit.transport.URIish;
import java.io.IOException;
import java.io.InputStream;

public class TransportBundleStream
extends Transport
implements TransportBundle {
    private InputStream src;

    public TransportBundleStream(Repository db, URIish uri, InputStream in) {
        super(db, uri);
        this.src = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchConnection openFetch() throws TransportException {
        if (this.src == null) {
            throw new TransportException(this.uri, JGitText.get().onlyOneFetchSupported);
        }
        try {
            BundleFetchConnection bundleFetchConnection = new BundleFetchConnection(this, this.src);
            return bundleFetchConnection;
        }
        finally {
            this.src = null;
        }
    }

    @Override
    public PushConnection openPush() throws NotSupportedException {
        throw new NotSupportedException(JGitText.get().pushIsNotSupportedForBundleTransport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.src != null) {
            try {
                this.src.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.src = null;
            }
        }
    }
}

