/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.transport;

import com.netflix.nebula.jgit.errors.UnsupportedCredentialItem;
import com.netflix.nebula.jgit.transport.CredentialItem;
import com.netflix.nebula.jgit.transport.CredentialsProvider;
import com.netflix.nebula.jgit.transport.URIish;
import java.util.Arrays;

public class UsernamePasswordCredentialsProvider
extends CredentialsProvider {
    private String username;
    private char[] password;

    public UsernamePasswordCredentialsProvider(String username, String password) {
        this(username, password.toCharArray());
    }

    public UsernamePasswordCredentialsProvider(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public boolean isInteractive() {
        return false;
    }

    @Override
    public boolean supports(CredentialItem ... items) {
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.Username || i instanceof CredentialItem.Password) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.Username) {
                ((CredentialItem.Username)i).setValue(this.username);
                continue;
            }
            if (i instanceof CredentialItem.Password) {
                ((CredentialItem.Password)i).setValue(this.password);
                continue;
            }
            if (i instanceof CredentialItem.StringType && i.getPromptText().equals("Password: ")) {
                ((CredentialItem.StringType)i).setValue(new String(this.password));
                continue;
            }
            throw new UnsupportedCredentialItem(uri, i.getClass().getName() + ":" + i.getPromptText());
        }
        return true;
    }

    public void clear() {
        this.username = null;
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
            this.password = null;
        }
    }
}

