/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.util;

import com.netflix.nebula.jgit.lib.Constants;
import com.netflix.nebula.jgit.lib.ObjectId;
import com.netflix.nebula.jgit.lib.ObjectInserter;
import com.netflix.nebula.jgit.lib.PersonIdent;
import java.util.regex.Pattern;

public class ChangeIdUtil {
    static final String CHANGE_ID = "Change-Id:";
    private static final Pattern issuePattern = Pattern.compile("^(Bug|Issue)[a-zA-Z0-9-]*:.*$");
    private static final Pattern footerPattern = Pattern.compile("(^[a-zA-Z0-9-]+:(?!//).*$)");
    private static final Pattern changeIdPattern = Pattern.compile("(^Change-Id: *I[a-f0-9]{40}$)");
    private static final Pattern includeInFooterPattern = Pattern.compile("^[ \\[].*$");
    private static final Pattern trailingWhitespace = Pattern.compile("\\s+$");

    static String clean(String msg) {
        return msg.replaceAll("(?i)(?m)^Signed-off-by:.*$\n?", "").replaceAll("(?m)^#.*$\n?", "").replaceAll("(?m)\n\n\n+", "\\\n").replaceAll("\\n*$", "").replaceAll("(?s)\ndiff --git.*", "").trim();
    }

    public static ObjectId computeChangeId(ObjectId treeId, ObjectId firstParentId, PersonIdent author, PersonIdent committer, String message) {
        String cleanMessage = ChangeIdUtil.clean(message);
        if (cleanMessage.length() == 0) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append("tree ");
        b.append(ObjectId.toString(treeId));
        b.append("\n");
        if (firstParentId != null) {
            b.append("parent ");
            b.append(ObjectId.toString(firstParentId));
            b.append("\n");
        }
        b.append("author ");
        b.append(author.toExternalString());
        b.append("\n");
        b.append("committer ");
        b.append(committer.toExternalString());
        b.append("\n\n");
        b.append(cleanMessage);
        try (ObjectInserter.Formatter f = new ObjectInserter.Formatter();){
            ObjectId objectId = f.idFor(1, Constants.encode(b.toString()));
            return objectId;
        }
    }

    public static String insertId(String message, ObjectId changeId) {
        return ChangeIdUtil.insertId(message, changeId, false);
    }

    public static String insertId(String message, ObjectId changeId, boolean replaceExisting) {
        int i;
        int footerFirstLine;
        int indexOfChangeId = ChangeIdUtil.indexOfChangeId(message, "\n");
        if (indexOfChangeId > 0) {
            if (!replaceExisting) {
                return message;
            }
            StringBuilder ret = new StringBuilder(message.substring(0, indexOfChangeId));
            ret.append(CHANGE_ID);
            ret.append(" I");
            ret.append(ObjectId.toString(changeId));
            int indexOfNextLineBreak = message.indexOf("\n", indexOfChangeId);
            if (indexOfNextLineBreak > 0) {
                ret.append(message.substring(indexOfNextLineBreak));
            }
            return ret.toString();
        }
        String[] lines = message.split("\n");
        int insertAfter = footerFirstLine = ChangeIdUtil.indexOfFirstFooterLine(lines);
        for (int i2 = footerFirstLine; i2 < lines.length && issuePattern.matcher(lines[i2]).matches(); ++i2) {
            insertAfter = i2 + 1;
        }
        StringBuilder ret = new StringBuilder();
        for (i = 0; i < insertAfter; ++i) {
            ret.append(lines[i]);
            ret.append("\n");
        }
        if (insertAfter == lines.length && insertAfter == footerFirstLine) {
            ret.append("\n");
        }
        ret.append(CHANGE_ID);
        ret.append(" I");
        ret.append(ObjectId.toString(changeId));
        ret.append("\n");
        while (i < lines.length) {
            ret.append(lines[i]);
            ret.append("\n");
            ++i;
        }
        return ret.toString();
    }

    public static int indexOfChangeId(String message, String delimiter) {
        String[] lines = message.split(delimiter);
        if (lines.length == 0) {
            return -1;
        }
        int indexOfChangeIdLine = 0;
        boolean inFooter = false;
        for (int i = lines.length - 1; i >= 0; --i) {
            if (!inFooter && ChangeIdUtil.isEmptyLine(lines[i])) continue;
            inFooter = true;
            if (changeIdPattern.matcher(ChangeIdUtil.trimRight(lines[i])).matches()) {
                indexOfChangeIdLine = i;
                break;
            }
            if (!ChangeIdUtil.isEmptyLine(lines[i]) && i != 0) continue;
            return -1;
        }
        int indexOfChangeIdLineinString = 0;
        for (int i = 0; i < indexOfChangeIdLine; ++i) {
            indexOfChangeIdLineinString += lines[i].length() + delimiter.length();
        }
        return indexOfChangeIdLineinString + lines[indexOfChangeIdLine].indexOf(CHANGE_ID);
    }

    private static boolean isEmptyLine(String line) {
        return line.trim().length() == 0;
    }

    private static String trimRight(String s) {
        return trailingWhitespace.matcher(s).replaceAll("");
    }

    public static int indexOfFirstFooterLine(String[] lines) {
        int footerFirstLine = lines.length;
        for (int i = lines.length - 1; i > 1; --i) {
            if (footerPattern.matcher(lines[i]).matches()) {
                footerFirstLine = i;
                continue;
            }
            if (footerFirstLine != lines.length && lines[i].length() == 0) break;
            if (footerFirstLine != lines.length && includeInFooterPattern.matcher(lines[i]).matches()) {
                footerFirstLine = i + 1;
                continue;
            }
            footerFirstLine = lines.length;
            break;
        }
        return footerFirstLine;
    }
}

