/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.transport;

import com.netflix.nebula.lint.jgit.errors.UnpackException;
import com.netflix.nebula.lint.jgit.lib.Constants;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.transport.BaseReceivePack;
import com.netflix.nebula.lint.jgit.transport.PostReceiveHook;
import com.netflix.nebula.lint.jgit.transport.PreReceiveHook;
import com.netflix.nebula.lint.jgit.transport.ReceiveCommand;
import com.netflix.nebula.lint.jgit.transport.RefAdvertiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ReceivePack
extends BaseReceivePack {
    private PreReceiveHook preReceive = PreReceiveHook.NULL;
    private PostReceiveHook postReceive = PostReceiveHook.NULL;
    private boolean reportStatus;
    private boolean echoCommandFailures;

    public ReceivePack(Repository into) {
        super(into);
    }

    public PreReceiveHook getPreReceiveHook() {
        return this.preReceive;
    }

    public void setPreReceiveHook(PreReceiveHook h) {
        this.preReceive = h != null ? h : PreReceiveHook.NULL;
    }

    public PostReceiveHook getPostReceiveHook() {
        return this.postReceive;
    }

    public void setPostReceiveHook(PostReceiveHook h) {
        this.postReceive = h != null ? h : PostReceiveHook.NULL;
    }

    public void setEchoCommandFailures(boolean echo) {
        this.echoCommandFailures = echo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(InputStream input, OutputStream output, OutputStream messages) throws IOException {
        this.init(input, output, messages);
        try {
            this.service();
        }
        finally {
            try {
                this.close();
            }
            finally {
                this.release();
            }
        }
    }

    @Override
    protected void enableCapabilities() {
        this.reportStatus = this.isCapabilityEnabled("report-status");
        super.enableCapabilities();
    }

    private void service() throws IOException {
        if (this.isBiDirectionalPipe()) {
            this.sendAdvertisedRefs(new RefAdvertiser.PacketLineOutRefAdvertiser(this.pckOut));
            this.pckOut.flush();
        } else {
            this.getAdvertisedOrDefaultRefs();
        }
        if (this.hasError()) {
            return;
        }
        this.recvCommands();
        if (this.hasCommands()) {
            this.enableCapabilities();
            Throwable unpackError = null;
            if (this.needPack()) {
                try {
                    this.receivePackAndCheckConnectivity();
                }
                catch (IOException err) {
                    unpackError = err;
                }
                catch (RuntimeException err) {
                    unpackError = err;
                }
                catch (Error err) {
                    unpackError = err;
                }
            }
            if (unpackError == null) {
                boolean atomic = this.isCapabilityEnabled("atomic");
                this.setAtomic(atomic);
                this.validateCommands();
                if (atomic && this.anyRejects()) {
                    this.failPendingCommands();
                }
                this.preReceive.onPreReceive(this, this.filterCommands(ReceiveCommand.Result.NOT_ATTEMPTED));
                if (atomic && this.anyRejects()) {
                    this.failPendingCommands();
                }
                this.executeCommands();
            }
            this.unlockPack();
            if (this.reportStatus) {
                if (this.echoCommandFailures && this.msgOut != null) {
                    this.sendStatusReport(false, unpackError, new BaseReceivePack.Reporter(){

                        @Override
                        void sendString(String s) throws IOException {
                            ReceivePack.this.msgOut.write(Constants.encode(s + "\n"));
                        }
                    });
                    this.msgOut.flush();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.sendStatusReport(true, unpackError, new BaseReceivePack.Reporter(){

                    @Override
                    void sendString(String s) throws IOException {
                        ReceivePack.this.pckOut.writeString(s + "\n");
                    }
                });
                this.pckOut.end();
            } else if (this.msgOut != null) {
                this.sendStatusReport(false, unpackError, new BaseReceivePack.Reporter(){

                    @Override
                    void sendString(String s) throws IOException {
                        ReceivePack.this.msgOut.write(Constants.encode(s + "\n"));
                    }
                });
            }
            if (unpackError != null) {
                try {
                    this.postReceive.onPostReceive(this, this.filterCommands(ReceiveCommand.Result.OK));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new UnpackException(unpackError);
            }
            this.postReceive.onPostReceive(this, this.filterCommands(ReceiveCommand.Result.OK));
        }
    }

    @Override
    protected String getLockMessageProcessName() {
        return "jgit receive-pack";
    }
}

