/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler.ast;

import com.netflix.nebula.lint.jdt.internal.compiler.ASTVisitor;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.BranchStatement;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.SubRoutineStatement;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.TryStatement;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowContext;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowInfo;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;

public class BreakStatement
extends BranchStatement {
    public BreakStatement(char[] label, int sourceStart, int e) {
        super(label, sourceStart, e);
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowContext targetContext;
        FlowContext flowContext2 = targetContext = this.label == null ? flowContext.getTargetContextForDefaultBreak() : flowContext.getTargetContextForBreakLabel(this.label);
        if (targetContext == null) {
            if (this.label == null) {
                currentScope.problemReporter().invalidBreak(this);
            } else {
                currentScope.problemReporter().undefinedLabel(this);
            }
            return flowInfo;
        }
        this.targetLabel = targetContext.breakLabel();
        FlowContext traversedContext = flowContext;
        int subIndex = 0;
        int maxSub = 5;
        this.subroutines = new SubRoutineStatement[maxSub];
        do {
            SubRoutineStatement sub;
            if ((sub = traversedContext.subRoutine()) != null) {
                if (subIndex == maxSub) {
                    this.subroutines = new SubRoutineStatement[maxSub *= 2];
                    System.arraycopy(this.subroutines, 0, this.subroutines, 0, subIndex);
                }
                this.subroutines[subIndex++] = sub;
                if (sub.isSubRoutineEscaping()) break;
            }
            traversedContext.recordReturnFrom(flowInfo.unconditionalInits());
            ASTNode node = traversedContext.associatedNode;
            if (node instanceof TryStatement) {
                TryStatement tryStatement = (TryStatement)node;
                flowInfo.addInitializationsFrom(tryStatement.subRoutineInits);
                continue;
            }
            if (traversedContext != targetContext) continue;
            targetContext.recordBreakFrom(flowInfo);
            break;
        } while ((traversedContext = traversedContext.parent) != null);
        if (subIndex != maxSub) {
            this.subroutines = new SubRoutineStatement[subIndex];
            System.arraycopy(this.subroutines, 0, this.subroutines, 0, subIndex);
        }
        return FlowInfo.DEAD_END;
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        BreakStatement.printIndent(tab, output).append("break ");
        if (this.label != null) {
            output.append(this.label);
        }
        return output.append(';');
    }

    public void traverse(ASTVisitor visitor, BlockScope blockscope) {
        visitor.visit(this, blockscope);
        visitor.endVisit(this, blockscope);
    }
}

