/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelManager;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelStatus;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;

public class JarEntryFile
extends PlatformObject
implements IStorage {
    private String entryName;
    private String zipName;
    private IPath path;

    public JarEntryFile(String entryName, String zipName) {
        this.entryName = entryName;
        this.zipName = zipName;
        this.path = new Path(this.entryName);
    }

    public InputStream getContents() throws CoreException {
        try {
            ZipFile zipFile;
            ZipEntry zipEntry;
            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [JarEntryFile.getContents()] Creating ZipFile on " + this.zipName);
            }
            if ((zipEntry = (zipFile = new ZipFile(this.zipName)).getEntry(this.entryName)) == null) {
                throw new JavaModelException(new JavaModelStatus(979, this.entryName));
            }
            return zipFile.getInputStream(zipEntry);
        }
        catch (IOException e) {
            throw new JavaModelException(e, 985);
        }
    }

    public IPath getFullPath() {
        return this.path;
    }

    public String getName() {
        return this.path.lastSegment();
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        return "JarEntryFile[" + this.zipName + "::" + this.entryName + "]";
    }
}

