/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.rule.dependency;

import com.netflix.nebula.lint.rule.GradleDependency;
import com.netflix.nebula.lint.rule.GradleLintRule;
import com.netflix.nebula.lint.rule.GradleModelAware;
import com.netflix.nebula.lint.rule.dependency.DependencyHelper;
import com.netflix.nebula.lint.rule.dependency.ModuleDescriptor;
import com.netflix.nebula.lint.rule.dependency.provider.MavenBomRecommendationProvider;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class RecommendedVersionsRule
extends GradleLintRule
implements GradleModelAware {
    private static final String GRADLE_VERSION_WITH_EXPERIMENTAL_FEATURES = "4.5";
    private static final String GRADLE_VERSION_WITH_OPT_IN_FEATURES = "4.6";
    private static final String GRADLE_VERSION_WITH_DEFAULT_FEATURES = "5.0";
    private static final String GRADLE_PROPERTIES = "gradle.properties";
    private static final String GRADLE_SETTINGS = "settings.gradle";
    private String description;
    private Map<String, Map<ModuleDescriptor, MethodCallExpression>> dependenciesPerConf;
    private MavenBomRecommendationProvider recommendationProvider;
    private Boolean recommenderIsEnabled;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public RecommendedVersionsRule() {
        MetaClass metaClass;
        String string;
        CallSite[] callSiteArray = RecommendedVersionsRule.$getCallSiteArray();
        this.description = string = "Remove versions from dependencies that are recommended";
        Object object = callSiteArray[0].call((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), (Object)new _closure1(this, this));
        this.dependenciesPerConf = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        Object var4_4 = null;
        this.recommenderIsEnabled = (Boolean)ScriptBytecodeAdapter.castToType(var4_4, Boolean.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public void visitGradleDependency(MethodCallExpression call, String conf, GradleDependency dep) {
        CallSite[] callSiteArray = RecommendedVersionsRule.$getCallSiteArray();
        callSiteArray[1].callCurrent((GroovyObject)this, (Object)call, (Object)conf, (Object)dep);
    }

    @Override
    public void visitSubprojectGradleDependency(MethodCallExpression call, String conf, GradleDependency dep) {
        CallSite[] callSiteArray = RecommendedVersionsRule.$getCallSiteArray();
        callSiteArray[2].callCurrent((GroovyObject)this, (Object)call, (Object)conf, (Object)dep);
    }

    @Override
    public void visitAllprojectsGradleDependency(MethodCallExpression call, String conf, GradleDependency dep) {
        CallSite[] callSiteArray = RecommendedVersionsRule.$getCallSiteArray();
        callSiteArray[3].callCurrent((GroovyObject)this, (Object)call, (Object)conf, (Object)dep);
    }

    private void handleDependencyVisit(MethodCallExpression call, String conf, GradleDependency dep) {
        CallSite[] callSiteArray = RecommendedVersionsRule.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.recommenderIsEnabled, null)) {
                Object object = callSiteArray[4].callCurrent((GroovyObject)this);
                this.recommenderIsEnabled = (Boolean)ScriptBytecodeAdapter.castToType((Object)object, Boolean.class);
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)this.recommenderIsEnabled, null)) {
            boolean bl = this.recommenderIsEnabled();
            this.recommenderIsEnabled = bl;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].callGroovyObjectGetProperty((Object)this)) && DefaultTypeTransformation.booleanUnbox((Object)this.recommenderIsEnabled)) {
            Object desc = callSiteArray[6].call(ModuleDescriptor.class, (Object)dep);
            callSiteArray[7].call(callSiteArray[8].call(this.dependenciesPerConf, (Object)conf), desc, (Object)call);
        }
    }

    @Override
    protected void visitClassComplete(ClassNode node) {
        CallSite[] callSiteArray = RecommendedVersionsRule.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.recommenderIsEnabled)) {
            return;
        }
        Object object = callSiteArray[9].callConstructor(MavenBomRecommendationProvider.class, callSiteArray[10].callGroovyObjectGetProperty((Object)this));
        this.recommendationProvider = (MavenBomRecommendationProvider)ScriptBytecodeAdapter.castToType((Object)object, MavenBomRecommendationProvider.class);
        public final class _visitClassComplete_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _visitClassComplete_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _visitClassComplete_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object conf, Object allDependencies) {
                CallSite[] callSiteArray = _visitClassComplete_closure2.$getCallSiteArray();
                public final class _closure4
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure4(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object desc, Object call) {
                        CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(desc)))) {
                            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callCurrent((GroovyObject)this, desc))) {
                                Object violation = callSiteArray[3].callCurrent((GroovyObject)this, (Object)"using a recommended dependency with a declared version, the version should be removed", call);
                                return callSiteArray[4].call(DependencyHelper.class, violation, call, callSiteArray[5].callConstructor(GradleDependency.class, callSiteArray[6].callGetProperty(desc), callSiteArray[7].callGetProperty(desc), callSiteArray[8].callGetProperty(desc)));
                            }
                            return null;
                        }
                        return null;
                    }

                    public Object call(Object desc, Object call) {
                        CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                        return callSiteArray[9].callCurrent((GroovyObject)this, desc, call);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "isEmpty";
                        stringArray[1] = "version";
                        stringArray[2] = "recommendationIsAvailable";
                        stringArray[3] = "addBuildLintViolation";
                        stringArray[4] = "removeVersion";
                        stringArray[5] = "<$constructor$>";
                        stringArray[6] = "group";
                        stringArray[7] = "name";
                        stringArray[8] = "version";
                        stringArray[9] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[10];
                        _closure4.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure4.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure4.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].call(allDependencies, (Object)new _closure4((Object)this, this.getThisObject()));
            }

            public Object call(Object conf, Object allDependencies) {
                CallSite[] callSiteArray = _visitClassComplete_closure2.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, conf, allDependencies);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _visitClassComplete_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "each";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _visitClassComplete_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_visitClassComplete_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _visitClassComplete_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[11].call(this.dependenciesPerConf, (Object)new _visitClassComplete_closure2(this, this));
    }

    private boolean recommendationIsAvailable(ModuleDescriptor desc) {
        CallSite[] callSiteArray = RecommendedVersionsRule.$getCallSiteArray();
        return ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[12].call((Object)this.recommendationProvider, callSiteArray[13].callGroovyObjectGetProperty((Object)desc), callSiteArray[14].callGroovyObjectGetProperty((Object)desc)), null);
    }

    private boolean recommenderIsEnabled() {
        CallSite[] callSiteArray = RecommendedVersionsRule.$getCallSiteArray();
        Object gradleVersion = callSiteArray[15].callGetProperty(callSiteArray[16].callGetProperty(callSiteArray[17].callGroovyObjectGetProperty((Object)this)));
        if (ScriptBytecodeAdapter.compareLessThan((Object)gradleVersion, (Object)GRADLE_VERSION_WITH_EXPERIMENTAL_FEATURES)) {
            return false;
        }
        Object rootProjectDir = callSiteArray[18].callGetProperty(callSiteArray[19].callGroovyObjectGetProperty((Object)this));
        if (ScriptBytecodeAdapter.compareLessThan((Object)gradleVersion, (Object)GRADLE_VERSION_WITH_OPT_IN_FEATURES)) {
            Object gradlePropertiesFiles = null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object;
                gradlePropertiesFiles = object = callSiteArray[20].callCurrent((GroovyObject)this, (Object)GRADLE_PROPERTIES);
            } else {
                List<File> list = this.findAllInPath(GRADLE_PROPERTIES);
                gradlePropertiesFiles = list;
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].call(gradlePropertiesFiles))) {
                return false;
            }
            Reference advancedPomPropertySet = new Reference((Object)false);
            Boolean cfr_ignored_0 = (Boolean)advancedPomPropertySet.get();
            public final class _recommenderIsEnabled_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference advancedPomPropertySet;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _recommenderIsEnabled_closure3(Object _outerInstance, Object _thisObject, Reference advancedPomPropertySet) {
                    Reference reference;
                    CallSite[] callSiteArray = _recommenderIsEnabled_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.advancedPomPropertySet = reference = advancedPomPropertySet;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _recommenderIsEnabled_closure3.$getCallSiteArray();
                    Reference props = new Reference(callSiteArray[0].callConstructor(Properties.class));
                    public final class _closure5
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference props;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure5(Object _outerInstance, Object _thisObject, Reference props) {
                            Reference reference;
                            CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.props = reference = props;
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                            return callSiteArray[0].call(this.props.get(), it);
                        }

                        public Object getProps() {
                            CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                            return this.props.get();
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure5.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[1];
                            stringArray[0] = "load";
                            return new CallSiteArray(_closure5.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure5.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    callSiteArray[1].call(callSiteArray[2].callConstructor(File.class, callSiteArray[3].call(it)), (Object)new _closure5((Object)this, this.getThisObject(), props));
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].call(props.get(), (Object)"org.gradle.advancedpomsupport"), (Object)"true")) {
                        boolean bl = true;
                        this.advancedPomPropertySet.set((Object)bl);
                        return bl;
                    }
                    return null;
                }

                public Boolean getAdvancedPomPropertySet() {
                    CallSite[] callSiteArray = _recommenderIsEnabled_closure3.$getCallSiteArray();
                    return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.advancedPomPropertySet.get(), Boolean.class);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _recommenderIsEnabled_closure3.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _recommenderIsEnabled_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "<$constructor$>";
                    stringArray[1] = "withInputStream";
                    stringArray[2] = "<$constructor$>";
                    stringArray[3] = "toString";
                    stringArray[4] = "getProperty";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[5];
                    _recommenderIsEnabled_closure3.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_recommenderIsEnabled_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _recommenderIsEnabled_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[22].call(gradlePropertiesFiles, (Object)new _recommenderIsEnabled_closure3(this, this, advancedPomPropertySet));
            Boolean experimentalFeaturesEnabled = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[23].callSafe(callSiteArray[24].callSafe(callSiteArray[25].call(callSiteArray[26].callGetProperty(callSiteArray[27].callGetProperty(callSiteArray[28].callGroovyObjectGetProperty((Object)this))), (Object)"experimentalFeatures")), (Object)"enabled"), (Object)true);
            return DefaultTypeTransformation.booleanUnbox((Object)((Boolean)advancedPomPropertySet.get())) && DefaultTypeTransformation.booleanUnbox((Object)experimentalFeaturesEnabled);
        }
        if (ScriptBytecodeAdapter.compareLessThan((Object)gradleVersion, (Object)GRADLE_VERSION_WITH_DEFAULT_FEATURES)) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[29].call(callSiteArray[30].call(callSiteArray[31].call(rootProjectDir)), callSiteArray[32].call(callSiteArray[33].call(callSiteArray[34].call(rootProjectDir), callSiteArray[35].callGetProperty(File.class)), (Object)GRADLE_SETTINGS)))) {
                return false;
            }
            Object settingsFile = callSiteArray[36].callConstructor(File.class, rootProjectDir, (Object)GRADLE_SETTINGS);
            Object advancedPomFeatureEnabled = callSiteArray[37].call(callSiteArray[38].callGetProperty(settingsFile), (Object)"enableFeaturePreview('IMPROVED_POM_SUPPORT')");
        }
        return true;
    }

    public List<File> findAllInPath(String fileName) {
        CallSite[] callSiteArray = RecommendedVersionsRule.$getCallSiteArray();
        Object foundFiles = callSiteArray[39].callConstructor(ArrayList.class);
        Object curr = callSiteArray[40].callGetProperty(callSiteArray[41].callGroovyObjectGetProperty((Object)this));
        while (ScriptBytecodeAdapter.compareNotEqual((Object)curr, (Object)callSiteArray[42].callGetProperty(callSiteArray[43].callGroovyObjectGetProperty((Object)this)))) {
            Object object;
            Object fileInCurrentProjectDir = callSiteArray[44].call(callSiteArray[45].call(callSiteArray[46].call(curr), callSiteArray[47].callGetProperty(File.class)), (Object)fileName);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].call(callSiteArray[49].call(callSiteArray[50].call(curr)), fileInCurrentProjectDir))) {
                callSiteArray[51].call(foundFiles, fileInCurrentProjectDir);
            }
            curr = object = callSiteArray[52].callGetProperty(curr);
        }
        Object fileInParentDir = callSiteArray[53].call(callSiteArray[54].call(callSiteArray[55].call(callSiteArray[56].callGetProperty(callSiteArray[57].callGroovyObjectGetProperty((Object)this))), callSiteArray[58].callGetProperty(File.class)), (Object)fileName);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[59].call(callSiteArray[60].call(callSiteArray[61].call(callSiteArray[62].callGetProperty(callSiteArray[63].callGroovyObjectGetProperty((Object)this)))), fileInParentDir))) {
            callSiteArray[64].call(foundFiles, fileInParentDir);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)foundFiles, List.class);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RecommendedVersionsRule.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String string) {
        this.description = string;
    }

    @Generated
    public Map<String, Map<ModuleDescriptor, MethodCallExpression>> getDependenciesPerConf() {
        return this.dependenciesPerConf;
    }

    @Generated
    public void setDependenciesPerConf(Map<String, Map<ModuleDescriptor, MethodCallExpression>> map) {
        this.dependenciesPerConf = map;
    }

    @Generated
    public MavenBomRecommendationProvider getRecommendationProvider() {
        return this.recommendationProvider;
    }

    @Generated
    public void setRecommendationProvider(MavenBomRecommendationProvider mavenBomRecommendationProvider) {
        this.recommendationProvider = mavenBomRecommendationProvider;
    }

    public /* synthetic */ void super$3$visitSubprojectGradleDependency(MethodCallExpression methodCallExpression, String string, GradleDependency gradleDependency) {
        super.visitSubprojectGradleDependency(methodCallExpression, string, gradleDependency);
    }

    public /* synthetic */ void super$3$visitGradleDependency(MethodCallExpression methodCallExpression, String string, GradleDependency gradleDependency) {
        super.visitGradleDependency(methodCallExpression, string, gradleDependency);
    }

    public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ void super$3$visitAllprojectsGradleDependency(MethodCallExpression methodCallExpression, String string, GradleDependency gradleDependency) {
        super.visitAllprojectsGradleDependency(methodCallExpression, string, gradleDependency);
    }

    public /* synthetic */ void super$2$visitClassComplete(ClassNode classNode) {
        super.visitClassComplete(classNode);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "withDefault";
        stringArray[1] = "handleDependencyVisit";
        stringArray[2] = "handleDependencyVisit";
        stringArray[3] = "handleDependencyVisit";
        stringArray[4] = "recommenderIsEnabled";
        stringArray[5] = "ignored";
        stringArray[6] = "fromGradleDependency";
        stringArray[7] = "put";
        stringArray[8] = "get";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "project";
        stringArray[11] = "each";
        stringArray[12] = "getVersion";
        stringArray[13] = "group";
        stringArray[14] = "name";
        stringArray[15] = "gradleVersion";
        stringArray[16] = "gradle";
        stringArray[17] = "project";
        stringArray[18] = "rootDir";
        stringArray[19] = "project";
        stringArray[20] = "findAllInPath";
        stringArray[21] = "isEmpty";
        stringArray[22] = "each";
        stringArray[23] = "get";
        stringArray[24] = "getProperties";
        stringArray[25] = "get";
        stringArray[26] = "properties";
        stringArray[27] = "gradle";
        stringArray[28] = "project";
        stringArray[29] = "contains";
        stringArray[30] = "toString";
        stringArray[31] = "listFiles";
        stringArray[32] = "plus";
        stringArray[33] = "plus";
        stringArray[34] = "toString";
        stringArray[35] = "separator";
        stringArray[36] = "<$constructor$>";
        stringArray[37] = "contains";
        stringArray[38] = "text";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "projectDir";
        stringArray[41] = "project";
        stringArray[42] = "rootDir";
        stringArray[43] = "project";
        stringArray[44] = "plus";
        stringArray[45] = "plus";
        stringArray[46] = "toString";
        stringArray[47] = "separator";
        stringArray[48] = "contains";
        stringArray[49] = "toString";
        stringArray[50] = "listFiles";
        stringArray[51] = "add";
        stringArray[52] = "parentFile";
        stringArray[53] = "plus";
        stringArray[54] = "plus";
        stringArray[55] = "toString";
        stringArray[56] = "rootDir";
        stringArray[57] = "project";
        stringArray[58] = "separator";
        stringArray[59] = "contains";
        stringArray[60] = "toString";
        stringArray[61] = "listFiles";
        stringArray[62] = "rootDir";
        stringArray[63] = "project";
        stringArray[64] = "add";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[65];
        RecommendedVersionsRule.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(RecommendedVersionsRule.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = RecommendedVersionsRule.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure1(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }

        @Generated
        public Object doCall() {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(_closure1.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure1.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

