/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler.flow;

import com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowContext;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowInfo;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ReferenceBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding;

public class InitializationFlowContext
extends ExceptionHandlingFlowContext {
    public int exceptionCount;
    public TypeBinding[] thrownExceptions = new TypeBinding[5];
    public ASTNode[] exceptionThrowers = new ASTNode[5];
    public FlowInfo[] exceptionThrowerFlowInfos = new FlowInfo[5];

    public InitializationFlowContext(FlowContext parent, ASTNode associatedNode, BlockScope scope) {
        super(parent, associatedNode, NoExceptions, scope, FlowInfo.DEAD_END);
    }

    public void checkInitializerExceptions(BlockScope currentScope, FlowContext initializerContext, FlowInfo flowInfo) {
        int i = 0;
        while (i < this.exceptionCount) {
            initializerContext.checkExceptionHandlers(this.thrownExceptions[i], this.exceptionThrowers[i], this.exceptionThrowerFlowInfos[i], currentScope);
            ++i;
        }
    }

    public String individualToString() {
        StringBuffer buffer = new StringBuffer("Initialization flow context");
        int i = 0;
        while (i < this.exceptionCount) {
            buffer.append('[').append(this.thrownExceptions[i].readableName());
            buffer.append('-').append(this.exceptionThrowerFlowInfos[i].toString()).append(']');
            ++i;
        }
        return buffer.toString();
    }

    public void recordHandlingException(ReferenceBinding exceptionType, UnconditionalFlowInfo flowInfo, TypeBinding raisedException, ASTNode invocationSite, boolean wasMasked) {
        int size = this.thrownExceptions.length;
        if (this.exceptionCount == size) {
            this.thrownExceptions = new TypeBinding[size * 2];
            System.arraycopy(this.thrownExceptions, 0, this.thrownExceptions, 0, size);
            this.exceptionThrowers = new ASTNode[size * 2];
            System.arraycopy(this.exceptionThrowers, 0, this.exceptionThrowers, 0, size);
            this.exceptionThrowerFlowInfos = new FlowInfo[size * 2];
            System.arraycopy(this.exceptionThrowerFlowInfos, 0, this.exceptionThrowerFlowInfos, 0, size);
        }
        this.thrownExceptions[this.exceptionCount] = raisedException;
        this.exceptionThrowers[this.exceptionCount] = invocationSite;
        this.exceptionThrowerFlowInfos[this.exceptionCount++] = flowInfo.copy();
    }
}

