/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.revwalk;

import com.netflix.nebula.lint.jgit.errors.IncorrectObjectTypeException;
import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.revwalk.BlockRevQueue;
import com.netflix.nebula.lint.jgit.revwalk.FIFORevQueue;
import com.netflix.nebula.lint.jgit.revwalk.Generator;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import java.io.IOException;

class TopoSortGenerator
extends Generator {
    private static final int TOPO_DELAY = 32;
    private final FIFORevQueue pending = new FIFORevQueue();
    private final int outputType;

    TopoSortGenerator(Generator s) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c;
        this.outputType = s.outputType() | 8;
        s.shareFreeList(this.pending);
        while ((c = s.next()) != null) {
            RevCommit[] revCommitArray = c.parents;
            int n = c.parents.length;
            int n2 = 0;
            while (n2 < n) {
                RevCommit p = revCommitArray[n2];
                ++p.inDegree;
                ++n2;
            }
            this.pending.add(c);
        }
    }

    @Override
    int outputType() {
        return this.outputType;
    }

    @Override
    void shareFreeList(BlockRevQueue q) {
        q.shareFreeList(this.pending);
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c;
        while (true) {
            if ((c = this.pending.next()) == null) {
                return null;
            }
            if (c.inDegree <= 0) break;
            c.flags |= 0x20;
        }
        RevCommit[] revCommitArray = c.parents;
        int n = c.parents.length;
        int n2 = 0;
        while (n2 < n) {
            RevCommit p = revCommitArray[n2];
            if (--p.inDegree == 0 && (p.flags & 0x20) != 0) {
                p.flags &= 0xFFFFFFDF;
                this.pending.unpop(p);
            }
            ++n2;
        }
        return c;
    }
}

