/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.IClassFile;
import com.netflix.nebula.lint.jdt.core.IJavaElement;
import com.netflix.nebula.lint.jdt.core.IPackageFragment;
import com.netflix.nebula.lint.jdt.core.IType;
import com.netflix.nebula.lint.jdt.core.ITypeParameter;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.Signature;
import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.internal.compiler.env.IBinaryField;
import com.netflix.nebula.lint.jdt.internal.compiler.env.IBinaryMethod;
import com.netflix.nebula.lint.jdt.internal.compiler.env.IBinaryNestedType;
import com.netflix.nebula.lint.jdt.internal.compiler.env.IBinaryType;
import com.netflix.nebula.lint.jdt.internal.compiler.util.SuffixConstants;
import com.netflix.nebula.lint.jdt.internal.core.BinaryField;
import com.netflix.nebula.lint.jdt.internal.core.BinaryMember;
import com.netflix.nebula.lint.jdt.internal.core.BinaryMethod;
import com.netflix.nebula.lint.jdt.internal.core.BinaryType;
import com.netflix.nebula.lint.jdt.internal.core.ClassFile;
import com.netflix.nebula.lint.jdt.internal.core.JavaElement;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelManager;
import com.netflix.nebula.lint.jdt.internal.core.OpenableElementInfo;
import com.netflix.nebula.lint.jdt.internal.core.TypeParameter;
import com.netflix.nebula.lint.jdt.internal.core.TypeParameterElementInfo;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;

class ClassFileInfo
extends OpenableElementInfo
implements SuffixConstants {
    protected JavaElement[] binaryChildren = null;
    protected ITypeParameter[] typeParameters;
    protected ClassFile classFile = null;

    ClassFileInfo(ClassFile classFile) {
        this.classFile = classFile;
    }

    private void generateFieldInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList childrenHandles) {
        IBinaryField[] fields = typeInfo.getFields();
        if (fields == null) {
            return;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int i = 0;
        int fieldCount = fields.length;
        while (i < fieldCount) {
            IBinaryField fieldInfo = fields[i];
            BinaryField field = new BinaryField((JavaElement)((Object)type), manager.intern(new String(fieldInfo.getName())));
            newElements.put(field, fieldInfo);
            childrenHandles.add(field);
            ++i;
        }
    }

    private void generateInnerClassHandles(IType type, IBinaryType typeInfo, ArrayList childrenHandles) {
        IBinaryNestedType[] innerTypes = typeInfo.getMemberTypes();
        if (innerTypes != null) {
            int i = 0;
            int typeCount = innerTypes.length;
            while (i < typeCount) {
                IBinaryNestedType binaryType = innerTypes[i];
                IClassFile parentClassFile = ((IPackageFragment)this.classFile.getParent()).getClassFile(String.valueOf(new String(ClassFile.unqualifiedName(binaryType.getName()))) + ".class");
                BinaryType innerType = new BinaryType((JavaElement)((Object)parentClassFile), ClassFile.simpleName(binaryType.getName()));
                childrenHandles.add(innerType);
                ++i;
            }
        }
    }

    private void generateMethodInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList childrenHandles, ArrayList typeParameterHandles) {
        IBinaryMethod[] methods = typeInfo.getMethods();
        if (methods == null) {
            return;
        }
        int i = 0;
        int methodCount = methods.length;
        while (i < methodCount) {
            IBinaryMethod methodInfo = methods[i];
            char[] signature = methodInfo.getGenericSignature();
            if (signature == null) {
                signature = methodInfo.getMethodDescriptor();
            }
            String[] pNames = null;
            try {
                pNames = Signature.getParameterTypes(new String(signature));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                signature = methodInfo.getMethodDescriptor();
                pNames = Signature.getParameterTypes(new String(signature));
            }
            char[][] paramNames = new char[pNames.length][];
            int j = 0;
            while (j < pNames.length) {
                paramNames[j] = pNames[j].toCharArray();
                ++j;
            }
            char[][] parameterTypes = ClassFile.translatedNames(paramNames);
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            String selector = new String(methodInfo.getSelector());
            if (methodInfo.isConstructor()) {
                selector = type.getElementName();
            }
            selector = manager.intern(selector);
            int j2 = 0;
            while (j2 < pNames.length) {
                pNames[j2] = manager.intern(new String(parameterTypes[j2]));
                ++j2;
            }
            BinaryMethod method = new BinaryMethod((JavaElement)((Object)type), selector, pNames);
            childrenHandles.add(method);
            while (newElements.containsKey(method)) {
                ++method.occurrenceCount;
            }
            newElements.put(method, methodInfo);
            this.generateTypeParameterInfos(method, signature, newElements, typeParameterHandles);
            ++i;
        }
    }

    private void generateTypeParameterInfos(BinaryMember parent, char[] signature, HashMap newElements, ArrayList typeParameterHandles) {
        if (signature == null) {
            return;
        }
        char[][] typeParameterSignatures = Signature.getTypeParameters(signature);
        int i = 0;
        int typeParameterCount = typeParameterSignatures.length;
        while (i < typeParameterCount) {
            char[] typeParameterSignature = typeParameterSignatures[i];
            char[] typeParameterName = Signature.getTypeVariable(typeParameterSignature);
            char[][] typeParameterBoundSignatures = Signature.getTypeParameterBounds(typeParameterSignature);
            int boundLength = typeParameterBoundSignatures.length;
            char[][] typeParameterBounds = new char[boundLength][];
            int j = 0;
            while (j < boundLength) {
                typeParameterBounds[j] = Signature.toCharArray(typeParameterBoundSignatures[j]);
                CharOperation.replace(typeParameterBounds[j], '/', '.');
                ++j;
            }
            TypeParameter typeParameter = new TypeParameter(parent, new String(typeParameterName));
            TypeParameterElementInfo info = new TypeParameterElementInfo();
            info.bounds = typeParameterBounds;
            typeParameterHandles.add(typeParameter);
            while (newElements.containsKey(typeParameter)) {
                ++typeParameter.occurrenceCount;
            }
            newElements.put(typeParameter, info);
            ++i;
        }
    }

    IJavaElement[] getBinaryChildren(HashMap newElements) {
        if (this.binaryChildren == null) {
            this.readBinaryChildren(newElements, null);
        }
        return this.binaryChildren;
    }

    boolean hasReadBinaryChildren() {
        return this.binaryChildren != null;
    }

    protected void readBinaryChildren(HashMap newElements, IBinaryType typeInfo) {
        ArrayList childrenHandles = new ArrayList();
        BinaryType type = null;
        try {
            type = (BinaryType)this.classFile.getType();
            if (typeInfo == null && (typeInfo = (IBinaryType)newElements.get(type)) == null) {
                typeInfo = this.classFile.getBinaryTypeInfo((IFile)this.classFile.getResource());
            }
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        ArrayList typeParameterHandles = new ArrayList();
        if (typeInfo != null) {
            this.generateTypeParameterInfos(type, typeInfo.getGenericSignature(), newElements, typeParameterHandles);
            this.generateFieldInfos(type, typeInfo, newElements, childrenHandles);
            this.generateMethodInfos(type, typeInfo, newElements, childrenHandles, typeParameterHandles);
            this.generateInnerClassHandles(type, typeInfo, childrenHandles);
        }
        this.binaryChildren = new JavaElement[childrenHandles.size()];
        childrenHandles.toArray(this.binaryChildren);
        int typeParameterHandleSize = typeParameterHandles.size();
        if (typeParameterHandleSize == 0) {
            this.typeParameters = TypeParameter.NO_TYPE_PARAMETERS;
        } else {
            this.typeParameters = new ITypeParameter[typeParameterHandleSize];
            typeParameterHandles.toArray(this.typeParameters);
        }
    }

    void removeBinaryChildren() throws JavaModelException {
        int i;
        JavaModelManager manager;
        if (this.binaryChildren != null) {
            manager = JavaModelManager.getJavaModelManager();
            i = 0;
            while (i < this.binaryChildren.length) {
                JavaElement child = this.binaryChildren[i];
                if (child instanceof BinaryType) {
                    manager.removeInfoAndChildren((JavaElement)child.getParent());
                } else {
                    manager.removeInfoAndChildren(child);
                }
                ++i;
            }
            this.binaryChildren = JavaElement.NO_ELEMENTS;
        }
        if (this.typeParameters != null) {
            manager = JavaModelManager.getJavaModelManager();
            i = 0;
            while (i < this.typeParameters.length) {
                TypeParameter typeParameter = (TypeParameter)this.typeParameters[i];
                manager.removeInfoAndChildren(typeParameter);
                ++i;
            }
            this.typeParameters = TypeParameter.NO_TYPE_PARAMETERS;
        }
    }
}

