/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.rule.dependency;

import com.netflix.nebula.lint.rule.dependency.DependencyService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012J0\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0010\u001a\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/netflix/nebula/lint/rule/dependency/DuplicateDependencyService;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "getProject", "()Lorg/gradle/api/Project;", "violationsForModule", "", "", "mvid", "Lorg/gradle/api/artifacts/ModuleVersionIdentifier;", "conf", "ignoredDependencies", "", "violationsForModules", "moduleIds", "Lorg/gradle/api/artifacts/Configuration;", "Companion", "gradle-lint-plugin"})
public final class DuplicateDependencyService {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Project project;
    @NotNull
    private static final Set<String> BLACKLISTED_CLASSES;
    public static final Companion Companion;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> violationsForModules(@NotNull List<? extends ModuleVersionIdentifier> moduleIds, @NotNull Configuration conf, @NotNull Set<? extends ModuleVersionIdentifier> ignoredDependencies) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(moduleIds, (String)"moduleIds");
        Intrinsics.checkParameterIsNotNull((Object)conf, (String)"conf");
        Intrinsics.checkParameterIsNotNull(ignoredDependencies, (String)"ignoredDependencies");
        Iterable iterable = $receiver$iv = (Iterable)moduleIds;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ModuleVersionIdentifier it = (ModuleVersionIdentifier)element$iv$iv;
            String string = conf.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"conf.name");
            Iterable list$iv$iv = this.violationsForModule(it, string, ignoredDependencies);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @NotNull
    public final List<String> violationsForModule(@NotNull ModuleVersionIdentifier mvid, @NotNull String conf, @NotNull Set<? extends ModuleVersionIdentifier> ignoredDependencies) {
        Intrinsics.checkParameterIsNotNull((Object)mvid, (String)"mvid");
        Intrinsics.checkParameterIsNotNull((Object)conf, (String)"conf");
        Intrinsics.checkParameterIsNotNull(ignoredDependencies, (String)"ignoredDependencies");
        dependencyService = DependencyService.forProject(this.project);
        if (ignoredDependencies.contains(mvid)) {
            return CollectionsKt.emptyList();
        }
        v0 = dependencyService.jarContents(mvid.getModule());
        if (v0 == null || (v0 = v0.getClasses()) == null) {
            return CollectionsKt.emptyList();
        }
        dependencyClasses = v0;
        v1 = dependencyService.artifactsByClass(conf);
        Intrinsics.checkExpressionValueIsNotNull(v1, (String)"dependencyService.artifactsByClass(conf)");
        var7_6 = v1;
        var8_7 = $receiver$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        var10_9 = $receiver$iv$iv;
        for (Map.Entry element$iv$iv : var10_9.entrySet()) {
            it = element$iv$iv;
            if (!(DuplicateDependencyService.BLACKLISTED_CLASSES.contains(it.getKey()) == false)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        var10_9 = $receiver$iv$iv;
        var11_10 = var10_9.entrySet().iterator();
        while (var11_10.hasNext()) {
            block16: {
                block17: {
                    it = element$iv$iv = var11_10.next();
                    artifacts = (Collection)it.getValue();
                    if (!dependencyClasses.contains(it.getKey())) ** GOTO lbl-1000
                    v2 = artifacts;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"artifacts");
                    $receiver$iv = v2;
                    if (!($receiver$iv instanceof Collection) || !((Collection)$receiver$iv).isEmpty()) break block17;
                    v3 = false;
                    break block16;
                }
                for (T element$iv : $receiver$iv) {
                    v4 = it = (ResolvedArtifact)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                    v5 = v4.getModuleVersion();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it.moduleVersion");
                    if (ignoredDependencies.contains(v5.getId())) ** GOTO lbl-1000
                    v6 = it.getModuleVersion();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it.moduleVersion");
                    v7 = v6.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"it.moduleVersion.id");
                    if (Intrinsics.areEqual((Object)v7.getModule(), (Object)mvid.getModule()) ^ true) {
                        v8 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v8 = false;
                    }
                    if (!v8) continue;
                    v3 = true;
                    break block16;
                }
                v3 = false;
            }
            if (v3) {
                v9 = true;
            } else lbl-1000:
            // 2 sources

            {
                v9 = false;
            }
            if (!v9) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        dupeDependencyClasses = destination$iv$iv;
        dupeClassesByDependency = new TreeMap<ModuleVersionIdentifier, Set>(DependencyService.DEPENDENCY_COMPARATOR);
        destination$iv$iv = $receiver$iv = dupeDependencyClasses;
        var10_9 = destination$iv$iv.entrySet().iterator();
        while (var10_9.hasNext()) {
            it = $className_resolvedArtifacts = (element$iv = (Map.Entry)var10_9.next());
            className = (String)it.getKey();
            it = $className_resolvedArtifacts;
            resolvedArtifacts = (Collection)it.getValue();
            v10 = resolvedArtifacts;
            Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"resolvedArtifacts");
            $receiver$iv = v10;
            for (T element$iv : $receiver$iv) {
                v11 = artifact = (ResolvedArtifact)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"artifact");
                v12 = v11.getModuleVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"artifact.moduleVersion");
                moduleId = v12.getId();
                if (!dupeClassesByDependency.containsKey(moduleId)) {
                    var20_20 = moduleId;
                    var21_21 = dupeClassesByDependency;
                    var22_22 = new LinkedHashSet<E>();
                    var21_21.put(var20_20, var22_22);
                }
                v13 = artifact.getModuleVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"artifact.moduleVersion");
                v14 = dupeClassesByDependency.get(v13.getId());
                if (v14 == null) {
                    Intrinsics.throwNpe();
                }
                v15 = (Set)v14;
                v16 = className;
                Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"className");
                v15.add(v16);
            }
        }
        violations = new ArrayList<E>();
        configuration = this.project.getConfigurations().getByName(conf);
        if (!dupeClassesByDependency.isEmpty()) {
            v17 = dupeClassesByDependency.keySet();
            Intrinsics.checkExpressionValueIsNotNull(v17, (String)"dupeClassesByDependency.keys");
            if (Intrinsics.areEqual((Object)mvid, (Object)((ModuleVersionIdentifier)CollectionsKt.first((Iterable)v17)))) {
                $receiver$iv = dupeClassesByDependency;
                var11_10 = $receiver$iv;
                var12_11 = var11_10.entrySet().iterator();
                while (var12_11.hasNext()) {
                    resolvedArtifacts = $resolvedMvid_classes = (element$iv = var12_11.next());
                    resolvedMvid = (ModuleVersionIdentifier)resolvedArtifacts.getKey();
                    resolvedArtifacts = $resolvedMvid_classes;
                    classes = (Set)resolvedArtifacts.getValue();
                    if (!(Intrinsics.areEqual((Object)mvid, (Object)resolvedMvid) ^ true)) continue;
                    message = mvid + " in " + configuration + " has " + classes.size() + " classes duplicated by " + resolvedMvid;
                    this.logger.info(message + ". Duplicate classes: " + classes);
                    violations.add(message + " (use --info for detailed class list)");
                }
            }
        }
        return violations;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public DuplicateDependencyService(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        Logger logger = LoggerFactory.getLogger(DuplicateDependencyService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(\u2026dencyService::class.java)");
        this.logger = logger;
    }

    static {
        Companion = new Companion(null);
        BLACKLISTED_CLASSES = SetsKt.setOf((Object[])new String[]{"package-info", "module-info"});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/netflix/nebula/lint/rule/dependency/DuplicateDependencyService$Companion;", "", "()V", "BLACKLISTED_CLASSES", "", "", "getBLACKLISTED_CLASSES", "()Ljava/util/Set;", "gradle-lint-plugin"})
    public static final class Companion {
        @NotNull
        public final Set<String> getBLACKLISTED_CLASSES() {
            return BLACKLISTED_CLASSES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

