/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.org.codenarc.rule;

import com.netflix.nebula.lint.org.codenarc.rule.AstVisitor;
import com.netflix.nebula.lint.org.codenarc.rule.Rule;
import com.netflix.nebula.lint.org.codenarc.rule.Violation;
import com.netflix.nebula.lint.org.codenarc.source.SourceCode;
import com.netflix.nebula.lint.org.codenarc.util.AstUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.control.SourceUnit;

public class AbstractAstVisitor
extends ClassCodeVisitorSupport
implements AstVisitor {
    private final List<Violation> violations = new ArrayList<Violation>();
    private Rule rule;
    private SourceCode sourceCode;
    private Set<Object> visited = new HashSet<Object>();
    private ClassNode currentClassNode = null;

    protected boolean isFirstVisit(Object expression) {
        if (this.visited.contains(expression)) {
            return false;
        }
        this.visited.add(expression);
        return true;
    }

    protected String sourceLineTrimmed(ASTNode node) {
        return this.sourceCode.line(AstUtil.findFirstNonAnnotationLine(node, this.sourceCode) - 1);
    }

    protected String sourceLine(ASTNode node) {
        return this.sourceCode.getLines().get(AstUtil.findFirstNonAnnotationLine(node, this.sourceCode) - 1);
    }

    protected String lastSourceLine(ASTNode node) {
        return this.sourceCode.getLines().get(node.getLastLineNumber() - 1);
    }

    protected String lastSourceLineTrimmed(ASTNode node) {
        return this.sourceCode.line(node.getLastLineNumber() - 1);
    }

    @Deprecated
    protected void addViolation(ASTNode node) {
        this.addViolation(node, null);
    }

    protected void addViolation(ASTNode node, String message) {
        int lineNumber = node.getLineNumber();
        if (lineNumber >= 0) {
            if (node instanceof AnnotatedNode) {
                lineNumber = AstUtil.findFirstNonAnnotationLine(node, this.sourceCode);
            }
            String sourceLine = this.sourceLineTrimmed(node);
            Violation violation = new Violation();
            violation.setRule(this.rule);
            violation.setLineNumber(lineNumber);
            violation.setSourceLine(sourceLine);
            violation.setMessage(message);
            this.violations.add(violation);
        }
    }

    protected void addViolation(Violation violation) {
        this.violations.add(violation);
    }

    protected SourceUnit getSourceUnit() {
        throw new RuntimeException("should never be called");
    }

    public final void visitClass(ClassNode node) {
        this.currentClassNode = node;
        this.visitClassEx(node);
        super.visitClass(node);
        this.visitClassComplete(node);
        this.currentClassNode = null;
    }

    protected void visitClassEx(ClassNode node) {
    }

    protected void visitClassComplete(ClassNode node) {
    }

    public final void visitMethod(MethodNode node) {
        if (this.shouldVisitMethod(node)) {
            this.visitMethodEx(node);
            if (node != null && node.getParameters() != null) {
                for (Parameter parameter : node.getParameters()) {
                    if (!parameter.hasInitialExpression()) continue;
                    parameter.getInitialExpression().visit((GroovyCodeVisitor)this);
                }
            }
            super.visitMethod(node);
            this.visitMethodComplete(node);
        }
    }

    protected boolean shouldVisitMethod(MethodNode node) {
        return true;
    }

    protected void visitMethodComplete(MethodNode node) {
    }

    protected void visitMethodEx(MethodNode node) {
    }

    @Override
    public void setRule(Rule rule) {
        this.rule = rule;
    }

    @Override
    public void setSourceCode(SourceCode sourceCode) {
        this.sourceCode = sourceCode;
    }

    @Override
    public List<Violation> getViolations() {
        return this.violations;
    }

    public Set<Object> getVisited() {
        return this.visited;
    }

    public Rule getRule() {
        return this.rule;
    }

    public SourceCode getSourceCode() {
        return this.sourceCode;
    }

    public void setVisited(Set<Object> visited) {
        this.visited = visited;
    }

    protected String getCurrentClassName() {
        return this.currentClassNode.getName();
    }

    protected ClassNode getCurrentClassNode() {
        return this.currentClassNode;
    }
}

