/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.rule.dependency;

import com.netflix.nebula.lint.rule.dependency.DependencyService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012J0\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0010\u001a\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/netflix/nebula/lint/rule/dependency/DuplicateDependencyService;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "getProject", "()Lorg/gradle/api/Project;", "violationsForModule", "", "", "mvid", "Lorg/gradle/api/artifacts/ModuleVersionIdentifier;", "conf", "ignoredDependencies", "", "violationsForModules", "moduleIds", "Lorg/gradle/api/artifacts/Configuration;", "Companion", "gradle-lint-plugin"})
public final class DuplicateDependencyService {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Project project;
    @NotNull
    private static final Set<String> BLACKLISTED_CLASSES;
    public static final Companion Companion;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> violationsForModules(@NotNull List<? extends ModuleVersionIdentifier> moduleIds, @NotNull Configuration conf, @NotNull Set<? extends ModuleVersionIdentifier> ignoredDependencies) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(moduleIds, (String)"moduleIds");
        Intrinsics.checkParameterIsNotNull((Object)conf, (String)"conf");
        Intrinsics.checkParameterIsNotNull(ignoredDependencies, (String)"ignoredDependencies");
        Iterable $this$flatMap$iv = moduleIds;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ModuleVersionIdentifier it = (ModuleVersionIdentifier)element$iv$iv;
            String string = conf.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"conf.name");
            Iterable list$iv$iv = this.violationsForModule(it, string, ignoredDependencies);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<String> violationsForModule(@NotNull ModuleVersionIdentifier mvid, @NotNull String conf, @NotNull Set<? extends ModuleVersionIdentifier> ignoredDependencies) {
        Intrinsics.checkParameterIsNotNull((Object)mvid, (String)"mvid");
        Intrinsics.checkParameterIsNotNull((Object)conf, (String)"conf");
        Intrinsics.checkParameterIsNotNull(ignoredDependencies, (String)"ignoredDependencies");
        dependencyService = DependencyService.forProject(this.project);
        if (ignoredDependencies.contains(mvid)) {
            return CollectionsKt.emptyList();
        }
        v0 = dependencyService.jarContents(mvid.getModule());
        if (v0 == null || (v0 = v0.getClasses()) == null) {
            return CollectionsKt.emptyList();
        }
        dependencyClasses = v0;
        v1 = dependencyService.artifactsByClass(conf);
        Intrinsics.checkExpressionValueIsNotNull(v1, (String)"dependencyService.artifactsByClass(conf)");
        $this$filter$iv = v1;
        $i$f$filter = false;
        var9_9 = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        var12_14 = $this$filterTo$iv$iv;
        var13_15 = false;
        var14_17 = var12_14.entrySet().iterator();
        while (var14_17.hasNext()) {
            it = element$iv$iv = var14_17.next();
            allowable = true;
            $this$forEach$iv = DuplicateDependencyService.BLACKLISTED_CLASSES;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                bc = (String)element$iv;
                v2 = it.getKey();
                Intrinsics.checkExpressionValueIsNotNull(v2, (String)"it.key");
                if (!StringsKt.contains$default((CharSequence)((CharSequence)v2), (CharSequence)bc, (boolean)false, (int)2, null)) continue;
                allowable = false;
            }
            if (!allowable) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        var12_14 = $this$filterTo$iv$iv;
        var13_15 = false;
        var14_17 = var12_14.entrySet().iterator();
        while (var14_17.hasNext()) {
            block17: {
                block18: {
                    it = element$iv$iv = var14_17.next();
                    artifacts = (Collection)it.getValue();
                    if (!dependencyClasses.contains(it.getKey())) ** GOTO lbl-1000
                    v3 = artifacts;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"artifacts");
                    $this$any$iv = v3;
                    $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block18;
                    v4 = false;
                    break block17;
                }
                for (T element$iv : $this$any$iv) {
                    v5 = it = (ResolvedArtifact)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
                    v6 = v5.getModuleVersion();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it.moduleVersion");
                    if (ignoredDependencies.contains(v6.getId())) ** GOTO lbl-1000
                    v7 = it.getModuleVersion();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"it.moduleVersion");
                    v8 = v7.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"it.moduleVersion.id");
                    if (Intrinsics.areEqual((Object)v8.getModule(), (Object)mvid.getModule()) ^ true) {
                        v9 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v9 = false;
                    }
                    if (!v9) continue;
                    v4 = true;
                    break block17;
                }
                v4 = false;
            }
            if (v4) {
                v10 = true;
            } else lbl-1000:
            // 2 sources

            {
                v10 = false;
            }
            if (!v10) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        dupeDependencyClasses = destination$iv$iv;
        dupeClassesByDependency = new TreeMap<ModuleVersionIdentifier, Set>(DependencyService.DEPENDENCY_COMPARATOR);
        $this$forEach$iv = dupeDependencyClasses;
        $i$f$forEach = false;
        destination$iv$iv = $this$forEach$iv;
        $i$f$filterTo = false;
        var12_14 = destination$iv$iv.entrySet().iterator();
        while (var12_14.hasNext()) {
            element$iv$iv = $className_resolvedArtifacts = (element$iv = (Map.Entry)var12_14.next());
            it = false;
            className = (String)element$iv$iv.getKey();
            element$iv$iv = $className_resolvedArtifacts;
            it = false;
            v11 = resolvedArtifacts = (Collection)element$iv$iv.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"resolvedArtifacts");
            $this$forEach$iv = v11;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                v12 = artifact = (ResolvedArtifact)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"artifact");
                v13 = v12.getModuleVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"artifact.moduleVersion");
                moduleId = v13.getId();
                if (!dupeClassesByDependency.containsKey(moduleId)) {
                    var23_36 = moduleId;
                    var24_37 = dupeClassesByDependency;
                    var25_38 = false;
                    var26_39 = new LinkedHashSet<E>();
                    var24_37.put(var23_36, var26_39);
                }
                v14 = artifact.getModuleVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"artifact.moduleVersion");
                v15 = dupeClassesByDependency.get(v14.getId());
                if (v15 == null) {
                    Intrinsics.throwNpe();
                }
                v16 = (Set)v15;
                v17 = className;
                Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"className");
                v16.add(v17);
            }
        }
        $i$f$forEach = false;
        violations = new ArrayList<E>();
        configuration = this.project.getConfigurations().getByName(conf);
        if (!dupeClassesByDependency.isEmpty()) {
            v18 = dupeClassesByDependency.keySet();
            Intrinsics.checkExpressionValueIsNotNull(v18, (String)"dupeClassesByDependency.keys");
            if (Intrinsics.areEqual((Object)mvid, (Object)((ModuleVersionIdentifier)CollectionsKt.first((Iterable)v18)))) {
                $this$forEach$iv = dupeClassesByDependency;
                $i$f$forEach = false;
                var12_14 = $this$forEach$iv;
                var13_15 = false;
                var14_17 = var12_14.entrySet().iterator();
                while (var14_17.hasNext()) {
                    className = $resolvedMvid_classes = (element$iv = var14_17.next());
                    var18_28 = false;
                    resolvedMvid = (ModuleVersionIdentifier)className.getKey();
                    className = $resolvedMvid_classes;
                    var18_28 = false;
                    classes = (Set)className.getValue();
                    if (!(Intrinsics.areEqual((Object)mvid, (Object)resolvedMvid) ^ true)) continue;
                    message = mvid + " in " + configuration + " has " + classes.size() + " classes duplicated by " + resolvedMvid;
                    this.logger.info(message + ". Duplicate classes: " + classes);
                    violations.add(message + " (use --info for detailed class list)");
                }
            }
        }
        return violations;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public DuplicateDependencyService(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        Logger logger = LoggerFactory.getLogger(DuplicateDependencyService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(\u2026dencyService::class.java)");
        this.logger = logger;
    }

    static {
        Companion = new Companion(null);
        BLACKLISTED_CLASSES = SetsKt.setOf((Object[])new String[]{"package-info", "module-info"});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/netflix/nebula/lint/rule/dependency/DuplicateDependencyService$Companion;", "", "()V", "BLACKLISTED_CLASSES", "", "", "getBLACKLISTED_CLASSES", "()Ljava/util/Set;", "gradle-lint-plugin"})
    public static final class Companion {
        @NotNull
        public final Set<String> getBLACKLISTED_CLASSES() {
            return BLACKLISTED_CLASSES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

