/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.treewalk.filter;

import com.netflix.nebula.lint.jgit.errors.IncorrectObjectTypeException;
import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.errors.StopWalkException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.treewalk.TreeWalk;
import com.netflix.nebula.lint.jgit.treewalk.filter.TreeFilter;
import java.io.IOException;
import java.text.MessageFormat;

public class TreeFilterMarker {
    private final TreeFilter[] filters;

    public TreeFilterMarker(TreeFilter[] markTreeFilters) {
        if (markTreeFilters.length > 32) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().treeFilterMarkerTooManyFilters, 32, markTreeFilters.length));
        }
        this.filters = new TreeFilter[markTreeFilters.length];
        System.arraycopy(markTreeFilters, 0, this.filters, 0, markTreeFilters.length);
    }

    public int getMarks(TreeWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        int marks = 0;
        int index = 0;
        while (index < this.filters.length) {
            TreeFilter filter = this.filters[index];
            if (filter != null) {
                try {
                    boolean marked = filter.include(walk);
                    if (marked) {
                        marks = (int)((long)marks | 1L << index);
                    }
                }
                catch (StopWalkException e) {
                    this.filters[index] = null;
                }
            }
            ++index;
        }
        return marks;
    }
}

