/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.transport;

import com.netflix.nebula.lint.jgit.dircache.DirCache;
import com.netflix.nebula.lint.jgit.dircache.DirCacheEditor;
import com.netflix.nebula.lint.jgit.dircache.DirCacheEntry;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.BatchRefUpdate;
import com.netflix.nebula.lint.jgit.lib.CommitBuilder;
import com.netflix.nebula.lint.jgit.lib.Constants;
import com.netflix.nebula.lint.jgit.lib.FileMode;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectInserter;
import com.netflix.nebula.lint.jgit.lib.ObjectLoader;
import com.netflix.nebula.lint.jgit.lib.ObjectReader;
import com.netflix.nebula.lint.jgit.lib.ObjectStream;
import com.netflix.nebula.lint.jgit.lib.PersonIdent;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.RefUpdate;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import com.netflix.nebula.lint.jgit.transport.PushCertificate;
import com.netflix.nebula.lint.jgit.transport.PushCertificateParser;
import com.netflix.nebula.lint.jgit.transport.ReceiveCommand;
import com.netflix.nebula.lint.jgit.treewalk.TreeWalk;
import com.netflix.nebula.lint.jgit.treewalk.filter.AndTreeFilter;
import com.netflix.nebula.lint.jgit.treewalk.filter.PathFilter;
import com.netflix.nebula.lint.jgit.treewalk.filter.PathFilterGroup;
import com.netflix.nebula.lint.jgit.treewalk.filter.TreeFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class PushCertificateStore
implements AutoCloseable {
    static final String REF_NAME = "refs/meta/push-certs";
    private final Repository db;
    private final List<PendingCert> pending;
    ObjectReader reader;
    RevCommit commit;

    public PushCertificateStore(Repository db) {
        this.db = db;
        this.pending = new ArrayList<PendingCert>();
    }

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
            this.commit = null;
        }
    }

    public PushCertificate get(String refName) throws IOException {
        if (this.reader == null) {
            this.load();
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (TreeWalk tw = this.newTreeWalk(refName);){
            return PushCertificateStore.read(tw);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Iterable<PushCertificate> getAll(final String refName) {
        return new Iterable<PushCertificate>(){

            @Override
            public Iterator<PushCertificate> iterator() {
                return new Iterator<PushCertificate>(refName){
                    private final String path;
                    private PushCertificate next;
                    private RevWalk rw;
                    {
                        this.path = PushCertificateStore.pathName(string);
                        try {
                            if ((this).PushCertificateStore.this.reader == null) {
                                PushCertificateStore.this.load();
                            }
                            if ((this).PushCertificateStore.this.commit != null) {
                                this.rw = new RevWalk((this).PushCertificateStore.this.reader);
                                this.rw.setTreeFilter(AndTreeFilter.create(PathFilterGroup.create(Collections.singleton(PathFilter.create(this.path))), TreeFilter.ANY_DIFF));
                                this.rw.setRewriteParents(false);
                                this.rw.markStart(this.rw.parseCommit((this).PushCertificateStore.this.commit));
                            } else {
                                this.rw = null;
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        try {
                            block19: {
                                if (this.next == null) {
                                    if (this.rw == null) {
                                        return false;
                                    }
                                    try {
                                        RevCommit c = this.rw.next();
                                        if (c != null) {
                                            Throwable throwable = null;
                                            Object var3_5 = null;
                                            try (TreeWalk tw = TreeWalk.forPath(this.rw.getObjectReader(), this.path, c.getTree());){
                                                this.next = PushCertificateStore.read(tw);
                                                break block19;
                                            }
                                            catch (Throwable throwable2) {
                                                if (throwable == null) {
                                                    throwable = throwable2;
                                                } else if (throwable != throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                                throw throwable;
                                            }
                                        }
                                        this.next = null;
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            }
                            boolean bl = this.next != null;
                            return bl;
                        }
                        finally {
                            if (this.next == null && this.rw != null) {
                                this.rw.close();
                                this.rw = null;
                            }
                        }
                    }

                    @Override
                    public PushCertificate next() {
                        this.hasNext();
                        PushCertificate n = this.next;
                        if (n == null) {
                            throw new NoSuchElementException();
                        }
                        this.next = null;
                        return n;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    void load() throws IOException {
        this.close();
        this.reader = this.db.newObjectReader();
        Ref ref = this.db.getRefDatabase().exactRef(REF_NAME);
        if (ref == null) {
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (RevWalk rw = new RevWalk(this.reader);){
            this.commit = rw.parseCommit(ref.getObjectId());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static PushCertificate read(TreeWalk tw) throws IOException {
        if (tw == null) return null;
        if ((tw.getRawMode(0) & 0x8000) != 32768) {
            return null;
        }
        ObjectLoader loader = tw.getObjectReader().open(tw.getObjectId(0), 3);
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            ObjectStream in = loader.openStream();
            try {
                PushCertificate pushCertificate;
                block15: {
                    BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)in, Constants.CHARSET));
                    try {
                        pushCertificate = PushCertificateParser.fromReader(r);
                        return pushCertificate;
                    }
                    finally {
                        if (r == null) break block15;
                        ((Reader)r).close();
                    }
                }
                if (in != null) {
                    in.close();
                }
                return pushCertificate;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public void put(PushCertificate cert, PersonIdent ident) {
        this.put(cert, ident, null);
    }

    public void put(PushCertificate cert, PersonIdent ident, Collection<ReceiveCommand> matching) {
        this.pending.add(new PendingCert(cert, ident, matching));
    }

    public RefUpdate.Result save() throws IOException {
        ObjectId newId = this.write();
        if (newId == null) {
            return RefUpdate.Result.NO_CHANGE;
        }
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ObjectInserter inserter = this.db.newObjectInserter();){
                RefUpdate.Result result = this.updateRef(newId);
                switch (result) {
                    case NO_CHANGE: 
                    case NEW: 
                    case FAST_FORWARD: {
                        this.pending.clear();
                        break;
                    }
                }
                RefUpdate.Result result2 = result;
                this.close();
                return result2;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            this.close();
            throw throwable;
        }
    }

    public boolean save(BatchRefUpdate batch) throws IOException {
        ObjectId newId = this.write();
        if (newId == null || newId.equals(this.commit)) {
            return false;
        }
        batch.addCommand(new ReceiveCommand(this.commit != null ? this.commit : ObjectId.zeroId(), newId, REF_NAME));
        return true;
    }

    public void clear() {
        this.pending.clear();
    }

    private ObjectId write() throws IOException {
        if (this.pending.isEmpty()) {
            return null;
        }
        if (this.reader == null) {
            this.load();
        }
        PushCertificateStore.sortPending(this.pending);
        ObjectId curr = this.commit;
        DirCache dc = this.newDirCache();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectInserter inserter = this.db.newObjectInserter();){
            for (PendingCert pc : this.pending) {
                curr = this.saveCert(inserter, dc, pc, curr);
            }
            inserter.flush();
            return curr;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void sortPending(List<PendingCert> pending) {
        Collections.sort(pending, new Comparator<PendingCert>(){

            @Override
            public int compare(PendingCert a, PendingCert b) {
                return Long.signum(a.ident.getWhen().getTime() - b.ident.getWhen().getTime());
            }
        });
    }

    private DirCache newDirCache() throws IOException {
        if (this.commit != null) {
            return DirCache.read(this.reader, this.commit.getTree());
        }
        return DirCache.newInCore();
    }

    private ObjectId saveCert(ObjectInserter inserter, DirCache dc, PendingCert pc, ObjectId curr) throws IOException {
        HashMap<String, ReceiveCommand> byRef;
        if (pc.matching != null) {
            byRef = new HashMap<String, ReceiveCommand>();
            for (ReceiveCommand cmd : pc.matching) {
                if (byRef.put(cmd.getRefName(), cmd) == null) continue;
                throw new IllegalStateException();
            }
        } else {
            byRef = null;
        }
        DirCacheEditor editor = dc.editor();
        String certText = String.valueOf(pc.cert.toText()) + pc.cert.getSignature();
        final ObjectId certId = inserter.insert(3, certText.getBytes(Constants.CHARSET));
        boolean any = false;
        for (ReceiveCommand cmd : pc.cert.getCommands()) {
            if (byRef != null && !PushCertificateStore.commandsEqual(cmd, (ReceiveCommand)byRef.get(cmd.getRefName()))) continue;
            any = true;
            editor.add(new DirCacheEditor.PathEdit(PushCertificateStore.pathName(cmd.getRefName())){

                @Override
                public void apply(DirCacheEntry ent) {
                    ent.setFileMode(FileMode.REGULAR_FILE);
                    ent.setObjectId(certId);
                }
            });
        }
        if (!any) {
            return curr;
        }
        editor.finish();
        CommitBuilder cb = new CommitBuilder();
        cb.setAuthor(pc.ident);
        cb.setCommitter(pc.ident);
        cb.setTreeId(dc.writeTree(inserter));
        if (curr != null) {
            cb.setParentId(curr);
        } else {
            cb.setParentIds(Collections.emptyList());
        }
        cb.setMessage(PushCertificateStore.buildMessage(pc.cert));
        return inserter.insert(1, cb.build());
    }

    private static boolean commandsEqual(ReceiveCommand c1, ReceiveCommand c2) {
        if (c1 == null || c2 == null) {
            return c1 == c2;
        }
        return c1.getRefName().equals(c2.getRefName()) && c1.getOldId().equals(c2.getOldId()) && c1.getNewId().equals(c2.getNewId());
    }

    private RefUpdate.Result updateRef(ObjectId newId) throws IOException {
        RefUpdate ru = this.db.updateRef(REF_NAME);
        ru.setExpectedOldObjectId(this.commit != null ? this.commit : ObjectId.zeroId());
        ru.setNewObjectId(newId);
        ru.setRefLogIdent(this.pending.get((int)(this.pending.size() - 1)).ident);
        ru.setRefLogMessage(JGitText.get().storePushCertReflog, false);
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk rw = new RevWalk(this.reader);){
            return ru.update(rw);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private TreeWalk newTreeWalk(String refName) throws IOException {
        if (this.commit == null) {
            return null;
        }
        return TreeWalk.forPath(this.reader, PushCertificateStore.pathName(refName), this.commit.getTree());
    }

    static String pathName(String refName) {
        return String.valueOf(refName) + "@{cert}";
    }

    private static String buildMessage(PushCertificate cert) {
        StringBuilder sb = new StringBuilder();
        if (cert.getCommands().size() == 1) {
            sb.append(MessageFormat.format(JGitText.get().storePushCertOneRef, cert.getCommands().get(0).getRefName()));
        } else {
            sb.append(MessageFormat.format(JGitText.get().storePushCertMultipleRefs, cert.getCommands().size()));
        }
        return sb.append('\n').toString();
    }

    private static class PendingCert {
        PushCertificate cert;
        PersonIdent ident;
        Collection<ReceiveCommand> matching;

        PendingCert(PushCertificate cert, PersonIdent ident, Collection<ReceiveCommand> matching) {
            this.cert = cert;
            this.ident = ident;
            this.matching = matching;
        }
    }
}

