/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.dfs;

import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsRefDatabase;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsRepository;
import com.netflix.nebula.lint.jgit.lib.ObjectIdRef;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.RefUpdate;
import com.netflix.nebula.lint.jgit.lib.SymbolicRef;
import com.netflix.nebula.lint.jgit.revwalk.RevObject;
import com.netflix.nebula.lint.jgit.revwalk.RevTag;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import java.io.IOException;

final class DfsRefUpdate
extends RefUpdate {
    private final DfsRefDatabase refdb;
    private Ref dstRef;
    private RevWalk rw;

    DfsRefUpdate(DfsRefDatabase refdb, Ref ref) {
        super(ref);
        this.refdb = refdb;
    }

    @Override
    protected DfsRefDatabase getRefDatabase() {
        return this.refdb;
    }

    @Override
    protected DfsRepository getRepository() {
        return this.refdb.getRepository();
    }

    @Override
    protected boolean tryLock(boolean deref) throws IOException {
        this.dstRef = this.getRef();
        if (deref) {
            this.dstRef = this.dstRef.getLeaf();
        }
        if (this.dstRef.isSymbolic()) {
            this.setOldObjectId(null);
        } else {
            this.setOldObjectId(this.dstRef.getObjectId());
        }
        return true;
    }

    @Override
    protected void unlock() {
    }

    @Override
    public RefUpdate.Result update(RevWalk walk) throws IOException {
        try {
            this.rw = walk;
            RefUpdate.Result result = super.update(walk);
            return result;
        }
        finally {
            this.rw = null;
        }
    }

    @Override
    protected RefUpdate.Result doUpdate(RefUpdate.Result desiredResult) throws IOException {
        RevObject obj = this.rw.parseAny(this.getNewObjectId());
        ObjectIdRef newRef = obj instanceof RevTag ? new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, this.dstRef.getName(), this.getNewObjectId(), this.rw.peel(obj).copy()) : new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, this.dstRef.getName(), this.getNewObjectId());
        if (this.getRefDatabase().compareAndPut(this.dstRef, newRef)) {
            this.getRefDatabase().stored(newRef);
            return desiredResult;
        }
        return RefUpdate.Result.LOCK_FAILURE;
    }

    @Override
    protected RefUpdate.Result doDelete(RefUpdate.Result desiredResult) throws IOException {
        if (this.getRefDatabase().compareAndRemove(this.dstRef)) {
            this.getRefDatabase().removed(this.dstRef.getName());
            return desiredResult;
        }
        return RefUpdate.Result.LOCK_FAILURE;
    }

    @Override
    protected RefUpdate.Result doLink(String target) throws IOException {
        SymbolicRef newRef = new SymbolicRef(this.dstRef.getName(), new ObjectIdRef.Unpeeled(Ref.Storage.NEW, target, null));
        if (this.getRefDatabase().compareAndPut(this.dstRef, newRef)) {
            this.getRefDatabase().stored(newRef);
            if (this.dstRef.getStorage() == Ref.Storage.NEW) {
                return RefUpdate.Result.NEW;
            }
            return RefUpdate.Result.FORCED;
        }
        return RefUpdate.Result.LOCK_FAILURE;
    }
}

