/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.rule.dependency;

import com.netflix.nebula.interop.GradleKt;
import com.netflix.nebula.lint.rule.GradleDependency;
import com.netflix.nebula.lint.rule.GradleLintRule;
import com.netflix.nebula.lint.rule.GradleModelAware;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.invocation.Gradle;

public class DeprecatedDependencyConfigurationRule
extends GradleLintRule
implements GradleModelAware {
    private String description;
    private final Map CONFIGURATION_REPLACEMENTS;
    private final String MINIMUM_GRADLE_VERSION;
    private final String PROJECT_METHOD_NAME;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public DeprecatedDependencyConfigurationRule() {
        MetaClass metaClass;
        String string;
        String string2;
        Map map;
        String string3;
        this.description = string3 = "Replace deprecated configurations in dependencies";
        this.CONFIGURATION_REPLACEMENTS = map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"compile", "implementation", "testCompile", "testImplementation", "runtime", "runtimeOnly"});
        this.MINIMUM_GRADLE_VERSION = string2 = "4.7";
        this.PROJECT_METHOD_NAME = string = "project";
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public void visitAnyGradleDependency(MethodCallExpression call, String conf, GradleDependency dep) {
        this.handleDependencyVisit(call, conf, dep);
    }

    @Override
    public void visitGradleDependency(MethodCallExpression call, String conf, GradleDependency dep) {
        this.handleDependencyVisit(call, conf, dep);
    }

    @Override
    public void visitSubprojectGradleDependency(MethodCallExpression call, String conf, GradleDependency dep) {
        this.handleDependencyVisit(call, conf, dep);
    }

    @Override
    public void visitAllprojectsGradleDependency(MethodCallExpression call, String conf, GradleDependency dep) {
        this.handleDependencyVisit(call, conf, dep);
    }

    @Override
    public void visitDependencies(MethodCallExpression call) {
        if (!GradleKt.versionLessThan((Gradle)this.getProject().getGradle(), (String)this.MINIMUM_GRADLE_VERSION)) {
            this.handleProjectDependencies(call);
        }
    }

    private void handleProjectDependencies(MethodCallExpression call) {
        CallSite[] callSiteArray = DeprecatedDependencyConfigurationRule.$getCallSiteArray();
        public final class _handleProjectDependencies_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _handleProjectDependencies_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _handleProjectDependencies_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _handleProjectDependencies_closure1.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it) instanceof MethodCallExpression;
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _handleProjectDependencies_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _handleProjectDependencies_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "expression";
                return new CallSiteArray(_handleProjectDependencies_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _handleProjectDependencies_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List statements = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].call(ScriptBytecodeAdapter.getPropertySpreadSafe(DeprecatedDependencyConfigurationRule.class, (Object)ScriptBytecodeAdapter.getPropertySpreadSafe(DeprecatedDependencyConfigurationRule.class, (Object)callSiteArray[2].callGetProperty(callSiteArray[3].callGetProperty((Object)call)), (String)"code"), (String)"statements")), (Object)new _handleProjectDependencies_closure1(this, this)), List.class);
        public final class _handleProjectDependencies_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _handleProjectDependencies_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _handleProjectDependencies_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object statement) {
                CallSite[] callSiteArray = _handleProjectDependencies_closure2.$getCallSiteArray();
                String configuration = ShortTypeHandling.castToString((Object)callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty(callSiteArray[2].callGetProperty(statement))));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)configuration))) {
                    MethodCallExpression statementMethodCallExpression = (MethodCallExpression)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callGetProperty(statement), MethodCallExpression.class);
                    public final class _closure3
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure3(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                            return it instanceof MethodCallExpression && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty((Object)((MethodCallExpression)ScriptBytecodeAdapter.castToType((Object)it, MethodCallExpression.class))), (Object)callSiteArray[1].callGroovyObjectGetProperty((Object)this));
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure3.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "methodAsString";
                            stringArray[1] = "PROJECT_METHOD_NAME";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[2];
                            _closure3.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure3.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure3.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    List projectDependencies = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].callGetProperty(callSiteArray[9].callGetProperty((Object)statementMethodCallExpression))), (Object)new _closure3((Object)this, this.getThisObject())), List.class);
                    if (!DefaultTypeTransformation.booleanUnbox((Object)projectDependencies)) {
                        return null;
                    }
                    String project = ShortTypeHandling.castToString((Object)callSiteArray[10].callCurrent((GroovyObject)this, callSiteArray[11].call(callSiteArray[12].callGetProperty(callSiteArray[13].callGetProperty(callSiteArray[14].call((Object)projectDependencies))))));
                    if (!DefaultTypeTransformation.booleanUnbox((Object)project)) {
                        return null;
                    }
                    String configurationReplacement = ShortTypeHandling.castToString((Object)callSiteArray[15].call(callSiteArray[16].callGroovyObjectGetProperty((Object)this), (Object)configuration));
                    return callSiteArray[17].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{configuration, configurationReplacement}, new String[]{"Configuration ", " has been deprecated and should be replaced with ", ""}), (Object)statementMethodCallExpression);
                }
                return null;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _handleProjectDependencies_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "value";
                stringArray[1] = "method";
                stringArray[2] = "expression";
                stringArray[3] = "containsKey";
                stringArray[4] = "CONFIGURATION_REPLACEMENTS";
                stringArray[5] = "expression";
                stringArray[6] = "findAll";
                stringArray[7] = "flatten";
                stringArray[8] = "expressions";
                stringArray[9] = "arguments";
                stringArray[10] = "extractProject";
                stringArray[11] = "first";
                stringArray[12] = "expressions";
                stringArray[13] = "arguments";
                stringArray[14] = "first";
                stringArray[15] = "get";
                stringArray[16] = "CONFIGURATION_REPLACEMENTS";
                stringArray[17] = "addBuildLintViolation";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[18];
                _handleProjectDependencies_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_handleProjectDependencies_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _handleProjectDependencies_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[4].call((Object)statements, (Object)new _handleProjectDependencies_closure2(this, this));
    }

    private String extractProject(Expression expression) {
        CallSite[] callSiteArray = DeprecatedDependencyConfigurationRule.$getCallSiteArray();
        if (expression instanceof ConstantExpression) {
            return ShortTypeHandling.castToString((Object)callSiteArray[5].callGetProperty((Object)expression));
        }
        return ShortTypeHandling.castToString(null);
    }

    private void handleDependencyVisit(MethodCallExpression call, String conf, GradleDependency dep) {
        CallSite[] callSiteArray = DeprecatedDependencyConfigurationRule.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].call((Object)this.CONFIGURATION_REPLACEMENTS, (Object)conf)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].call(GradleKt.class, callSiteArray[8].callGetProperty(callSiteArray[9].callGroovyObjectGetProperty((Object)this)), (Object)this.MINIMUM_GRADLE_VERSION))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[10].call(callSiteArray[11].callGetProperty(callSiteArray[12].callGetProperty((Object)call))), (Object)1)) {
                callSiteArray[13].callCurrent((GroovyObject)this, (Object)call, (Object)conf, (Object)dep);
            } else {
                callSiteArray[14].callCurrent((GroovyObject)this, (Object)call, (Object)conf);
            }
        }
    }

    private void replaceSingleLineDependencyConfiguration(MethodCallExpression call, String conf, GradleDependency dep) {
        String configurationReplacement = ShortTypeHandling.castToString(this.CONFIGURATION_REPLACEMENTS.get(conf));
        this.addBuildLintViolation(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{conf, configurationReplacement}, new String[]{"Configuration ", " has been deprecated and should be replaced with ", ""})), (ASTNode)call);
    }

    private void replaceMultiLineDependencyConfiguration(MethodCallExpression call, String conf) {
        String configurationReplacement = ShortTypeHandling.castToString(this.CONFIGURATION_REPLACEMENTS.get(conf));
        this.addBuildLintViolation(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{conf, configurationReplacement}, new String[]{"Configuration ", " has been deprecated and should be replaced with ", ""})), (ASTNode)call);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DeprecatedDependencyConfigurationRule.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String string) {
        this.description = string;
    }

    public /* synthetic */ void super$3$visitAnyGradleDependency(MethodCallExpression methodCallExpression, String string, GradleDependency gradleDependency) {
        super.visitAnyGradleDependency(methodCallExpression, string, gradleDependency);
    }

    public /* synthetic */ void super$3$visitSubprojectGradleDependency(MethodCallExpression methodCallExpression, String string, GradleDependency gradleDependency) {
        super.visitSubprojectGradleDependency(methodCallExpression, string, gradleDependency);
    }

    public /* synthetic */ void super$3$visitDependencies(MethodCallExpression methodCallExpression) {
        super.visitDependencies(methodCallExpression);
    }

    public /* synthetic */ void super$3$visitGradleDependency(MethodCallExpression methodCallExpression, String string, GradleDependency gradleDependency) {
        super.visitGradleDependency(methodCallExpression, string, gradleDependency);
    }

    public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ void super$3$visitAllprojectsGradleDependency(MethodCallExpression methodCallExpression, String string, GradleDependency gradleDependency) {
        super.visitAllprojectsGradleDependency(methodCallExpression, string, gradleDependency);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "findAll";
        stringArray[1] = "flatten";
        stringArray[2] = "expressions";
        stringArray[3] = "arguments";
        stringArray[4] = "each";
        stringArray[5] = "value";
        stringArray[6] = "containsKey";
        stringArray[7] = "versionLessThan";
        stringArray[8] = "gradle";
        stringArray[9] = "project";
        stringArray[10] = "size";
        stringArray[11] = "expressions";
        stringArray[12] = "arguments";
        stringArray[13] = "replaceSingleLineDependencyConfiguration";
        stringArray[14] = "replaceMultiLineDependencyConfiguration";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[15];
        DeprecatedDependencyConfigurationRule.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DeprecatedDependencyConfigurationRule.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DeprecatedDependencyConfigurationRule.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

