/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.ICompilationUnit;
import com.netflix.nebula.lint.jdt.core.IJavaElement;
import com.netflix.nebula.lint.jdt.core.IJavaModelStatus;
import com.netflix.nebula.lint.jdt.core.IType;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.Signature;
import com.netflix.nebula.lint.jdt.core.dom.ASTNode;
import com.netflix.nebula.lint.jdt.core.dom.MethodDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.SimpleName;
import com.netflix.nebula.lint.jdt.core.dom.SingleVariableDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.rewrite.ASTRewrite;
import com.netflix.nebula.lint.jdt.internal.core.CreateTypeMemberOperation;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelStatus;
import com.netflix.nebula.lint.jdt.internal.core.util.Messages;
import com.netflix.nebula.lint.jdt.internal.core.util.Util;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IDocument;

public class CreateMethodOperation
extends CreateTypeMemberOperation {
    protected String[] parameterTypes;

    public CreateMethodOperation(IType parentElement, String source, boolean force) {
        super(parentElement, source, force);
    }

    protected String[] convertASTMethodTypesToSignatures() {
        if (this.parameterTypes == null && this.createdNode != null) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)this.createdNode;
            List parameters = methodDeclaration.parameters();
            int size = parameters.size();
            this.parameterTypes = new String[size];
            Iterator iterator = parameters.iterator();
            int i = 0;
            while (i < size) {
                SingleVariableDeclaration parameter = (SingleVariableDeclaration)iterator.next();
                String typeSig = Util.getSignature(parameter.getType());
                int extraDimensions = parameter.getExtraDimensions();
                if (methodDeclaration.isVarargs() && i == size - 1) {
                    ++extraDimensions;
                }
                this.parameterTypes[i] = Signature.createArraySignature(typeSig, extraDimensions);
                ++i;
            }
        }
        return this.parameterTypes;
    }

    protected ASTNode generateElementAST(ASTRewrite rewriter, IDocument document, ICompilationUnit cu) throws JavaModelException {
        ASTNode node = super.generateElementAST(rewriter, document, cu);
        if (node.getNodeType() != 31) {
            throw new JavaModelException(new JavaModelStatus(984));
        }
        return node;
    }

    protected IJavaElement generateResultHandle() {
        String[] types = this.convertASTMethodTypesToSignatures();
        String name = this.getASTNodeName();
        return this.getType().getMethod(name, types);
    }

    private String getASTNodeName() {
        return ((MethodDeclaration)this.createdNode).getName().getIdentifier();
    }

    public String getMainTaskName() {
        return Messages.operation_createMethodProgress;
    }

    protected SimpleName rename(ASTNode node, SimpleName newName) {
        MethodDeclaration method = (MethodDeclaration)node;
        SimpleName oldName = method.getName();
        method.setName(newName);
        return oldName;
    }

    protected IJavaModelStatus verifyNameCollision() {
        String[] types;
        String name;
        IType type;
        if (this.createdNode != null && (type = this.getType()).getMethod(name = ((MethodDeclaration)this.createdNode).isConstructor() ? type.getElementName() : this.getASTNodeName(), types = this.convertASTMethodTypesToSignatures()).exists()) {
            return new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, name));
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

