/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.pack;

public class PackExt {
    private static volatile PackExt[] VALUES = new PackExt[0];
    public static final PackExt PACK = PackExt.newPackExt("pack");
    public static final PackExt INDEX = PackExt.newPackExt("idx");
    public static final PackExt KEEP = PackExt.newPackExt("keep");
    public static final PackExt BITMAP_INDEX = PackExt.newPackExt("bitmap");
    public static final PackExt REFTABLE = PackExt.newPackExt("ref");
    private final String ext;
    private final int pos;

    public static PackExt[] values() {
        return VALUES;
    }

    public static synchronized PackExt newPackExt(String ext) {
        PackExt value;
        PackExt[] dst = new PackExt[VALUES.length + 1];
        int i = 0;
        while (i < VALUES.length) {
            PackExt packExt = VALUES[i];
            if (packExt.getExtension().equals(ext)) {
                return packExt;
            }
            dst[i] = packExt;
            ++i;
        }
        if (VALUES.length >= 32) {
            throw new IllegalStateException("maximum number of pack extensions exceeded");
        }
        dst[PackExt.VALUES.length] = value = new PackExt(ext, VALUES.length);
        VALUES = dst;
        return value;
    }

    private PackExt(String ext, int pos) {
        this.ext = ext;
        this.pos = pos;
    }

    public String getExtension() {
        return this.ext;
    }

    public int getPosition() {
        return this.pos;
    }

    public int getBit() {
        return 1 << this.getPosition();
    }

    public String toString() {
        return String.format("PackExt[%s, bit=0x%s]", this.getExtension(), Integer.toHexString(this.getBit()));
    }
}

