/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler.lookup;

import com.netflix.nebula.lint.jdt.internal.compiler.lookup.LookupEnvironment;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.MethodBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ReferenceBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.Scope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.Substitution;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedMethodBinding
extends MethodBinding {
    protected MethodBinding originalMethod;

    public ParameterizedMethodBinding(final ParameterizedTypeBinding parameterizedDeclaringClass, MethodBinding originalMethod) {
        super(originalMethod.modifiers, originalMethod.selector, originalMethod.returnType, originalMethod.parameters, originalMethod.thrownExceptions, parameterizedDeclaringClass);
        this.originalMethod = originalMethod;
        final TypeVariableBinding[] originalVariables = originalMethod.typeVariables;
        Substitution substitution = null;
        final int length = originalVariables.length;
        final boolean isStatic = originalMethod.isStatic();
        if (length == 0) {
            this.typeVariables = NoTypeVariables;
            if (!isStatic) {
                substitution = parameterizedDeclaringClass;
            }
        } else {
            TypeVariableBinding originalVariable;
            final TypeVariableBinding[] substitutedVariables = new TypeVariableBinding[length];
            int i = 0;
            while (i < length) {
                originalVariable = originalVariables[i];
                substitutedVariables[i] = new TypeVariableBinding(originalVariable.sourceName, this, originalVariable.rank);
                ++i;
            }
            this.typeVariables = substitutedVariables;
            substitution = new Substitution(){

                public LookupEnvironment environment() {
                    return parameterizedDeclaringClass.environment;
                }

                public boolean isRawSubstitution() {
                    return !isStatic && parameterizedDeclaringClass.isRawSubstitution();
                }

                public TypeBinding substitute(TypeVariableBinding typeVariable) {
                    if (typeVariable.rank < length && originalVariables[typeVariable.rank] == typeVariable) {
                        return substitutedVariables[typeVariable.rank];
                    }
                    if (!isStatic) {
                        return parameterizedDeclaringClass.substitute(typeVariable);
                    }
                    return typeVariable;
                }
            };
            i = 0;
            while (i < length) {
                originalVariable = originalVariables[i];
                TypeVariableBinding substitutedVariable = substitutedVariables[i];
                TypeBinding substitutedSuperclass = Scope.substitute(substitution, originalVariable.superclass);
                substitutedVariable.superclass = (ReferenceBinding)(substitutedSuperclass.isArrayType() ? parameterizedDeclaringClass.environment.getType(JAVA_LANG_OBJECT) : substitutedSuperclass);
                substitutedVariable.superInterfaces = Scope.substitute(substitution, originalVariable.superInterfaces);
                if (originalVariable.firstBound != null) {
                    substitutedVariable.firstBound = originalVariable.firstBound == originalVariable.superclass ? substitutedSuperclass : substitutedVariable.superInterfaces[0];
                }
                ++i;
            }
        }
        if (substitution != null) {
            this.returnType = Scope.substitute(substitution, this.returnType);
            this.parameters = Scope.substitute(substitution, this.parameters);
            this.thrownExceptions = Scope.substitute(substitution, this.thrownExceptions);
        }
    }

    public ParameterizedMethodBinding() {
    }

    public static ParameterizedMethodBinding instantiateGetClass(TypeBinding receiverType, MethodBinding originalMethod, Scope scope) {
        ParameterizedMethodBinding method = new ParameterizedMethodBinding();
        method.modifiers = originalMethod.modifiers;
        method.selector = originalMethod.selector;
        method.declaringClass = originalMethod.declaringClass;
        method.typeVariables = NoTypeVariables;
        method.originalMethod = originalMethod;
        method.parameters = originalMethod.parameters;
        method.thrownExceptions = originalMethod.thrownExceptions;
        ReferenceBinding genericClassType = scope.getJavaLangClass();
        method.returnType = scope.environment().createParameterizedType(genericClassType, new TypeBinding[]{scope.environment().createWildcard(genericClassType, 0, receiverType.erasure(), null, 1)}, null);
        return method;
    }

    public boolean hasSubstitutedParameters() {
        return this.parameters != this.originalMethod.parameters;
    }

    public boolean hasSubstitutedReturnType() {
        return this.returnType != this.originalMethod.returnType;
    }

    public MethodBinding original() {
        return this.originalMethod.original();
    }
}

