/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.api.GitCommand;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.errors.ConfigInvalidException;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.lib.StoredConfig;
import com.netflix.nebula.lint.jgit.submodule.SubmoduleWalk;
import com.netflix.nebula.lint.jgit.treewalk.filter.PathFilterGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class SubmoduleInitCommand
extends GitCommand<Collection<String>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleInitCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleInitCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    @Override
    public Collection<String> call() throws GitAPIException {
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
                if (!this.paths.isEmpty()) {
                    generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
                }
                StoredConfig config = this.repo.getConfig();
                ArrayList<String> initialized = new ArrayList<String>();
                while (generator.next()) {
                    if (generator.getConfigUrl() != null) continue;
                    String path = generator.getPath();
                    String name = generator.getModuleName();
                    String url = generator.getRemoteUrl();
                    String update = generator.getModulesUpdate();
                    if (url != null) {
                        config.setString("submodule", name, "url", url);
                    }
                    if (update != null) {
                        config.setString("submodule", name, "update", update);
                    }
                    if (url == null && update == null) continue;
                    initialized.add(path);
                }
                if (!initialized.isEmpty()) {
                    config.save();
                }
                return initialized;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

