/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.plugin;

import com.netflix.nebula.lint.GradleViolation;
import com.netflix.nebula.lint.org.codenarc.rule.Rule;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.gradle.internal.deprecation.DeprecatedFeatureUsage;
import org.gradle.internal.featurelifecycle.DeprecatedUsageProgressDetails;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/netflix/nebula/lint/plugin/ViolationDeprecatedUsageProgressDetails;", "Lorg/gradle/internal/featurelifecycle/DeprecatedUsageProgressDetails;", "violation", "Lcom/netflix/nebula/lint/GradleViolation;", "(Lcom/netflix/nebula/lint/GradleViolation;)V", "getAdvice", "", "getContextualAdvice", "getDocumentationUrl", "getRemovalDetails", "getStackTrace", "", "Ljava/lang/StackTraceElement;", "getSummary", "getType", "gradle-lint-plugin"})
public final class ViolationDeprecatedUsageProgressDetails
implements DeprecatedUsageProgressDetails {
    private final GradleViolation violation;

    @NotNull
    public String getSummary() {
        Rule rule = this.violation.getRule();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "Lint rule was violated: %s [%s:%s]";
        Object[] objectArray = new Object[3];
        objectArray[0] = this.violation.getMessage();
        Rule rule2 = rule;
        Intrinsics.checkExpressionValueIsNotNull((Object)rule2, (String)"rule");
        objectArray[1] = rule2.getName();
        objectArray[2] = rule.getPriority();
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @NotNull
    public String getRemovalDetails() {
        return this.violation.getSourceLine() != null ? "Source line: " + this.violation.getSourceLine() : "Refer to the full lint report for more details";
    }

    @Nullable
    public String getAdvice() {
        return null;
    }

    @Nullable
    public String getContextualAdvice() {
        return null;
    }

    @Nullable
    public String getDocumentationUrl() {
        return this.violation.getDocumentationUri();
    }

    @NotNull
    public String getType() {
        return this.violation.getLineNumber() != null ? DeprecatedFeatureUsage.Type.USER_CODE_DIRECT.name() : DeprecatedFeatureUsage.Type.BUILD_INVOCATION.name();
    }

    @NotNull
    public List<StackTraceElement> getStackTrace() {
        File file = this.violation.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"violation.file");
        String fileName = file.getAbsolutePath();
        Integer n = this.violation.getLineNumber();
        int lineNumber = n != null ? n : -1;
        StackTraceElement element = new StackTraceElement("build", "lint", fileName, lineNumber);
        return CollectionsKt.listOf((Object)element);
    }

    public ViolationDeprecatedUsageProgressDetails(@NotNull GradleViolation violation) {
        Intrinsics.checkParameterIsNotNull((Object)violation, (String)"violation");
        this.violation = violation;
    }
}

