/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core.search.matching;

import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.core.search.SearchPattern;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.IIndexConstants;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.AndPattern;

public class PackageReferencePattern
extends AndPattern
implements IIndexConstants {
    protected char[] pkgName;
    protected char[][] segments;
    protected int currentSegment;
    protected static char[][] CATEGORIES = new char[][]{REF};

    public PackageReferencePattern(char[] pkgName, int matchRule) {
        this(matchRule);
        if (pkgName == null || pkgName.length == 0) {
            this.pkgName = null;
            this.segments = new char[][]{CharOperation.NO_CHAR};
            this.mustResolve = false;
        } else {
            this.pkgName = this.isCaseSensitive() ? pkgName : CharOperation.toLowerCase(pkgName);
            this.segments = CharOperation.splitOn('.', this.pkgName);
            this.mustResolve = true;
        }
    }

    PackageReferencePattern(int matchRule) {
        super(1, matchRule);
    }

    public void decodeIndexKey(char[] key) {
        this.pkgName = key;
    }

    public SearchPattern getBlankPattern() {
        return new PackageReferencePattern(8);
    }

    public char[] getIndexKey() {
        if (this.currentSegment >= 0) {
            return this.segments[this.currentSegment];
        }
        return null;
    }

    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    protected boolean hasNextQuery() {
        return --this.currentSegment >= (this.segments.length >= 4 ? 2 : 0);
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        return true;
    }

    protected void resetQuery() {
        this.currentSegment = this.segments.length - 1;
    }

    protected StringBuffer print(StringBuffer output) {
        output.append("PackageReferencePattern: <");
        if (this.pkgName != null) {
            output.append(this.pkgName);
        } else {
            output.append("*");
        }
        output.append(">");
        return super.print(output);
    }
}

