/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.file;

import com.netflix.nebula.lint.jgit.annotations.Nullable;
import com.netflix.nebula.lint.jgit.errors.LockFailedException;
import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.internal.storage.file.LockFile;
import com.netflix.nebula.lint.jgit.internal.storage.file.RefDirectory;
import com.netflix.nebula.lint.jgit.internal.storage.file.ReflogWriter;
import com.netflix.nebula.lint.jgit.lib.BatchRefUpdate;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectIdRef;
import com.netflix.nebula.lint.jgit.lib.PersonIdent;
import com.netflix.nebula.lint.jgit.lib.ProgressMonitor;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.revwalk.RevObject;
import com.netflix.nebula.lint.jgit.revwalk.RevTag;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import com.netflix.nebula.lint.jgit.transport.ReceiveCommand;
import com.netflix.nebula.lint.jgit.util.RefList;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class PackedBatchRefUpdate
extends BatchRefUpdate {
    private RefDirectory refdb;

    PackedBatchRefUpdate(RefDirectory refdb) {
        super(refdb);
        this.refdb = refdb;
    }

    @Override
    public void execute(RevWalk walk, ProgressMonitor monitor, List<String> options) throws IOException {
        if (!this.isAtomic()) {
            super.execute(walk, monitor, options);
            return;
        }
        List<ReceiveCommand> pending = ReceiveCommand.filter(this.getCommands(), ReceiveCommand.Result.NOT_ATTEMPTED);
        if (pending.isEmpty()) {
            return;
        }
        if (pending.size() == 1) {
            super.execute(walk, monitor, options);
            return;
        }
        if (PackedBatchRefUpdate.containsSymrefs(pending)) {
            PackedBatchRefUpdate.reject(pending.get(0), ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().atomicSymRefNotSupported, pending);
            return;
        }
        if (!this.blockUntilTimestamps(MAX_WAIT)) {
            return;
        }
        if (options != null) {
            this.setPushOptions(options);
        }
        if (!this.checkConflictingNames(pending)) {
            return;
        }
        if (!this.checkObjectExistence(walk, pending)) {
            return;
        }
        if (!this.checkNonFastForwards(walk, pending)) {
            return;
        }
        try {
            this.refdb.pack(pending.stream().map(ReceiveCommand::getRefName).collect(Collectors.toList()));
        }
        catch (LockFailedException e) {
            PackedBatchRefUpdate.lockFailure(pending.get(0), pending);
            return;
        }
        Map<String, LockFile> locks = null;
        this.refdb.inProcessPackedRefsLock.lock();
        try {
            RefDirectory.PackedRefList oldPackedList;
            if (!this.refdb.isInClone()) {
                locks = this.lockLooseRefs(pending);
                if (locks == null) {
                    return;
                }
                oldPackedList = this.refdb.pack(locks);
            } else {
                oldPackedList = this.refdb.getPackedRefs();
            }
            RefList<Ref> newRefs = PackedBatchRefUpdate.applyUpdates(walk, oldPackedList, pending);
            if (newRefs == null) {
                return;
            }
            LockFile packedRefsLock = this.refdb.lockPackedRefs();
            if (packedRefsLock == null) {
                PackedBatchRefUpdate.lockFailure(pending.get(0), pending);
                return;
            }
            this.refdb.commitPackedRefs(packedRefsLock, newRefs, oldPackedList, true);
        }
        finally {
            try {
                PackedBatchRefUpdate.unlockAll(locks);
            }
            finally {
                this.refdb.inProcessPackedRefsLock.unlock();
            }
        }
        this.refdb.fireRefsChanged();
        pending.forEach(c -> c.setResult(ReceiveCommand.Result.OK));
        this.writeReflog(pending);
    }

    private static boolean containsSymrefs(List<ReceiveCommand> commands) {
        for (ReceiveCommand cmd : commands) {
            if (cmd.getOldSymref() == null && cmd.getNewSymref() == null) continue;
            return true;
        }
        return false;
    }

    private boolean checkConflictingNames(List<ReceiveCommand> commands) throws IOException {
        HashSet<String> takenNames = new HashSet<String>();
        HashSet<String> takenPrefixes = new HashSet<String>();
        HashSet<String> deletes = new HashSet<String>();
        for (ReceiveCommand cmd : commands) {
            if (cmd.getType() != ReceiveCommand.Type.DELETE) {
                takenNames.add(cmd.getRefName());
                PackedBatchRefUpdate.addPrefixesTo(cmd.getRefName(), takenPrefixes);
                continue;
            }
            deletes.add(cmd.getRefName());
        }
        Set<String> initialRefs = this.refdb.getRefs("").keySet();
        for (String name : initialRefs) {
            if (deletes.contains(name)) continue;
            takenNames.add(name);
            PackedBatchRefUpdate.addPrefixesTo(name, takenPrefixes);
        }
        for (ReceiveCommand cmd : commands) {
            if (cmd.getType() != ReceiveCommand.Type.DELETE && takenPrefixes.contains(cmd.getRefName())) {
                PackedBatchRefUpdate.lockFailure(cmd, commands);
                return false;
            }
            for (String prefix : PackedBatchRefUpdate.getPrefixes(cmd.getRefName())) {
                if (!takenNames.contains(prefix)) continue;
                PackedBatchRefUpdate.lockFailure(cmd, commands);
                return false;
            }
        }
        return true;
    }

    private boolean checkObjectExistence(RevWalk walk, List<ReceiveCommand> commands) throws IOException {
        for (ReceiveCommand cmd : commands) {
            try {
                if (cmd.getNewId().equals(ObjectId.zeroId())) continue;
                walk.parseAny(cmd.getNewId());
            }
            catch (MissingObjectException e) {
                PackedBatchRefUpdate.reject(cmd, ReceiveCommand.Result.REJECTED_MISSING_OBJECT, commands);
                return false;
            }
        }
        return true;
    }

    private boolean checkNonFastForwards(RevWalk walk, List<ReceiveCommand> commands) throws IOException {
        if (this.isAllowNonFastForwards()) {
            return true;
        }
        for (ReceiveCommand cmd : commands) {
            cmd.updateType(walk);
            if (cmd.getType() != ReceiveCommand.Type.UPDATE_NONFASTFORWARD) continue;
            PackedBatchRefUpdate.reject(cmd, ReceiveCommand.Result.REJECTED_NONFASTFORWARD, commands);
            return false;
        }
        return true;
    }

    @Nullable
    private Map<String, LockFile> lockLooseRefs(List<ReceiveCommand> commands) throws IOException {
        ReceiveCommand failed = null;
        HashMap<String, LockFile> locks = new HashMap<String, LockFile>();
        try {
            block4: for (int ms : this.refdb.getRetrySleepMs()) {
                failed = null;
                PackedBatchRefUpdate.unlockAll(locks);
                locks.clear();
                RefDirectory.sleep(ms);
                for (ReceiveCommand c : commands) {
                    LockFile lock;
                    String name = c.getRefName();
                    if (locks.put(name, lock = new LockFile(this.refdb.fileFor(name))) != null) {
                        throw new IOException(MessageFormat.format(JGitText.get().duplicateRef, name));
                    }
                    if (lock.lock()) continue;
                    failed = c;
                    continue block4;
                }
                HashMap<String, LockFile> result = locks;
                locks = null;
                HashMap<String, LockFile> hashMap = result;
                return hashMap;
            }
        }
        finally {
            PackedBatchRefUpdate.unlockAll(locks);
        }
        PackedBatchRefUpdate.lockFailure(failed != null ? failed : commands.get(0), commands);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static RefList<Ref> applyUpdates(RevWalk walk, RefList<Ref> refs, List<ReceiveCommand> commands) throws IOException {
        nDeletes = 0;
        adds = new ArrayList<ReceiveCommand>(commands.size());
        for (ReceiveCommand c : commands) {
            if (c.getType() == ReceiveCommand.Type.CREATE) {
                adds.add(c);
                continue;
            }
            if (c.getType() != ReceiveCommand.Type.DELETE) continue;
            ++nDeletes;
        }
        addIdx = 0;
        byName = PackedBatchRefUpdate.byName(commands);
        b = new RefList.Builder<Ref>(refs.size() - nDeletes + adds.size());
        for (Ref ref : refs) {
            name = ref.getName();
            cmd = byName.remove(name);
            if (cmd == null) {
                b.add(ref);
                continue;
            }
            if (cmd.getOldId().equals(ref.getObjectId())) ** GOTO lbl28
            PackedBatchRefUpdate.lockFailure(cmd, commands);
            return null;
            while ((currAdd = (ReceiveCommand)adds.get(addIdx)).getRefName().compareTo(name) < 0) {
                b.add(PackedBatchRefUpdate.peeledRef(walk, currAdd));
                byName.remove(currAdd.getRefName());
                ++addIdx;
lbl28:
                // 2 sources

                if (addIdx < adds.size()) continue;
            }
            if (cmd.getType() == ReceiveCommand.Type.DELETE) continue;
            b.add(PackedBatchRefUpdate.peeledRef(walk, cmd));
        }
        while (addIdx < adds.size()) {
            cmd = (ReceiveCommand)adds.get(addIdx++);
            byName.remove(cmd.getRefName());
            b.add(PackedBatchRefUpdate.peeledRef(walk, cmd));
        }
        if (!byName.isEmpty()) {
            PackedBatchRefUpdate.lockFailure(byName.values().iterator().next(), commands);
            return null;
        }
        return b.toRefList();
    }

    private void writeReflog(List<ReceiveCommand> commands) {
        PersonIdent ident = this.getRefLogIdent();
        if (ident == null) {
            ident = new PersonIdent(this.refdb.getRepository());
        }
        for (ReceiveCommand cmd : commands) {
            String strResult;
            if (cmd.getResult() != ReceiveCommand.Result.OK) continue;
            String name = cmd.getRefName();
            if (cmd.getType() == ReceiveCommand.Type.DELETE) {
                try {
                    RefDirectory.delete(this.refdb.logFor(name), RefDirectory.levelsIn(name));
                }
                catch (IOException iOException) {}
                continue;
            }
            if (this.isRefLogDisabled(cmd)) continue;
            String msg = this.getRefLogMessage(cmd);
            if (this.isRefLogIncludingResult(cmd) && (strResult = this.toResultString(cmd)) != null) {
                msg = msg.isEmpty() ? strResult : String.valueOf(msg) + ": " + strResult;
            }
            try {
                new ReflogWriter(this.refdb, this.isForceRefLog(cmd)).log(name, cmd.getOldId(), cmd.getNewId(), ident, msg);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String toResultString(ReceiveCommand cmd) {
        switch (cmd.getType()) {
            case CREATE: {
                return "created";
            }
            case UPDATE: {
                return this.isAllowNonFastForwards() ? "forced-update" : "fast-forward";
            }
            case UPDATE_NONFASTFORWARD: {
                return "forced-update";
            }
        }
        return null;
    }

    private static Map<String, ReceiveCommand> byName(List<ReceiveCommand> commands) {
        LinkedHashMap<String, ReceiveCommand> ret = new LinkedHashMap<String, ReceiveCommand>();
        for (ReceiveCommand cmd : commands) {
            ret.put(cmd.getRefName(), cmd);
        }
        return ret;
    }

    private static Ref peeledRef(RevWalk walk, ReceiveCommand cmd) throws IOException {
        ObjectId newId = cmd.getNewId().copy();
        RevObject obj = walk.parseAny(newId);
        if (obj instanceof RevTag) {
            return new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, cmd.getRefName(), newId, walk.peel(obj).copy());
        }
        return new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, cmd.getRefName(), newId);
    }

    private static void unlockAll(@Nullable Map<?, LockFile> locks) {
        if (locks != null) {
            locks.values().forEach(LockFile::unlock);
        }
    }

    private static void lockFailure(ReceiveCommand cmd, List<ReceiveCommand> commands) {
        PackedBatchRefUpdate.reject(cmd, ReceiveCommand.Result.LOCK_FAILURE, commands);
    }

    private static void reject(ReceiveCommand cmd, ReceiveCommand.Result result, List<ReceiveCommand> commands) {
        PackedBatchRefUpdate.reject(cmd, result, null, commands);
    }

    private static void reject(ReceiveCommand cmd, ReceiveCommand.Result result, String why, List<ReceiveCommand> commands) {
        cmd.setResult(result, why);
        for (ReceiveCommand c2 : commands) {
            if (c2.getResult() != ReceiveCommand.Result.OK) continue;
            c2.setResult(ReceiveCommand.Result.NOT_ATTEMPTED);
        }
        ReceiveCommand.abort(commands);
    }
}

