/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.reftable;

import com.netflix.nebula.lint.jgit.annotations.Nullable;
import com.netflix.nebula.lint.jgit.internal.storage.io.BlockSource;
import com.netflix.nebula.lint.jgit.internal.storage.reftable.LogCursor;
import com.netflix.nebula.lint.jgit.internal.storage.reftable.RefCursor;
import com.netflix.nebula.lint.jgit.internal.storage.reftable.ReftableConfig;
import com.netflix.nebula.lint.jgit.internal.storage.reftable.ReftableReader;
import com.netflix.nebula.lint.jgit.internal.storage.reftable.ReftableWriter;
import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.SymbolicRef;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;

public abstract class Reftable
implements AutoCloseable {
    protected boolean includeDeletes;

    public static Reftable from(Collection<Ref> refs) {
        try {
            ReftableConfig cfg = new ReftableConfig();
            cfg.setIndexObjects(false);
            cfg.setAlignBlocks(false);
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            new ReftableWriter().setConfig(cfg).begin(buf).sortAndWriteRefs(refs).finish();
            return new ReftableReader(BlockSource.from(buf.toByteArray()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setIncludeDeletes(boolean deletes) {
        this.includeDeletes = deletes;
    }

    public abstract RefCursor allRefs() throws IOException;

    public abstract RefCursor seekRef(String var1) throws IOException;

    public abstract RefCursor byObjectId(AnyObjectId var1) throws IOException;

    public abstract LogCursor allLogs() throws IOException;

    public LogCursor seekLog(String refName) throws IOException {
        return this.seekLog(refName, Long.MAX_VALUE);
    }

    public abstract LogCursor seekLog(String var1, long var2) throws IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Ref exactRef(String refName) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RefCursor rc = this.seekRef(refName);){
            return rc.next() ? rc.getRef() : null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public boolean hasRef(String refName) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RefCursor rc = this.seekRef(refName);){
            return rc.next();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean hasId(AnyObjectId id) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RefCursor rc = this.byObjectId(id);){
            return rc.next();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Nullable
    public Ref resolve(Ref symref) throws IOException {
        return this.resolve(symref, 0);
    }

    private Ref resolve(Ref ref, int depth) throws IOException {
        if (!ref.isSymbolic()) {
            return ref;
        }
        Ref dst = ref.getTarget();
        if (5 <= depth) {
            return null;
        }
        if ((dst = this.exactRef(dst.getName())) == null) {
            return ref;
        }
        if ((dst = this.resolve(dst, depth + 1)) == null) {
            return null;
        }
        return new SymbolicRef(ref.getName(), dst);
    }

    @Override
    public abstract void close() throws IOException;
}

