/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.dfs;

import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.Config;
import java.text.MessageFormat;

public class DfsBlockCacheConfig {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    private long blockLimit;
    private int blockSize;
    private double streamRatio;
    private int concurrencyLevel;

    public DfsBlockCacheConfig() {
        this.setBlockLimit(0x2000000L);
        this.setBlockSize(65536);
        this.setStreamRatio(0.3);
        this.setConcurrencyLevel(32);
    }

    public long getBlockLimit() {
        return this.blockLimit;
    }

    public DfsBlockCacheConfig setBlockLimit(long newLimit) {
        if (newLimit <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().blockLimitNotPositive, newLimit));
        }
        this.blockLimit = newLimit;
        return this;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public DfsBlockCacheConfig setBlockSize(int newSize) {
        int size = Math.max(512, newSize);
        if ((size & size - 1) != 0) {
            throw new IllegalArgumentException(JGitText.get().blockSizeNotPowerOf2);
        }
        this.blockSize = size;
        return this;
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public DfsBlockCacheConfig setConcurrencyLevel(int newConcurrencyLevel) {
        this.concurrencyLevel = newConcurrencyLevel;
        return this;
    }

    public double getStreamRatio() {
        return this.streamRatio;
    }

    public DfsBlockCacheConfig setStreamRatio(double ratio) {
        this.streamRatio = Math.max(0.0, Math.min(ratio, 1.0));
        return this;
    }

    public DfsBlockCacheConfig fromConfig(Config rc) {
        int cfgBlockSize;
        long cfgBlockLimit = rc.getLong("core", "dfs", "blockLimit", this.getBlockLimit());
        if (cfgBlockLimit % (long)(cfgBlockSize = rc.getInt("core", "dfs", "blockSize", this.getBlockSize())) != 0L) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().blockLimitNotMultipleOfBlockSize, cfgBlockLimit, cfgBlockSize));
        }
        this.setBlockLimit(cfgBlockLimit);
        this.setBlockSize(cfgBlockSize);
        this.setConcurrencyLevel(rc.getInt("core", "dfs", "concurrencyLevel", this.getConcurrencyLevel()));
        String v = rc.getString("core", "dfs", "streamRatio");
        if (v != null) {
            try {
                this.setStreamRatio(Double.parseDouble(v));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported3, "core", "dfs", "streamRatio", v));
            }
        }
        return this;
    }
}

