/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.Flags;
import com.netflix.nebula.lint.jdt.core.IMethod;
import com.netflix.nebula.lint.jdt.core.IType;
import com.netflix.nebula.lint.jdt.core.ITypeParameter;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.Signature;
import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.internal.compiler.ISourceElementRequestor;
import com.netflix.nebula.lint.jdt.internal.compiler.SourceElementRequestorAdapter;
import com.netflix.nebula.lint.jdt.internal.compiler.env.IBinaryMethod;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.Binding;
import com.netflix.nebula.lint.jdt.internal.core.Assert;
import com.netflix.nebula.lint.jdt.internal.core.BinaryMember;
import com.netflix.nebula.lint.jdt.internal.core.ClassFile;
import com.netflix.nebula.lint.jdt.internal.core.JavaElement;
import com.netflix.nebula.lint.jdt.internal.core.ResolvedBinaryMethod;
import com.netflix.nebula.lint.jdt.internal.core.SourceMapper;
import com.netflix.nebula.lint.jdt.internal.core.TypeParameter;
import com.netflix.nebula.lint.jdt.internal.core.util.Util;

class BinaryMethod
extends BinaryMember
implements IMethod {
    protected String[] parameterTypes;
    protected String[] parameterNames;
    protected static final String[] NO_TYPES = new String[0];
    protected String[] exceptionTypes;
    protected String returnType;

    protected BinaryMethod(JavaElement parent, String name, String[] paramTypes) {
        super(parent, name);
        Assert.isTrue(name.indexOf(46) == -1);
        this.parameterTypes = paramTypes == null ? NO_TYPES : paramTypes;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BinaryMethod)) {
            return false;
        }
        return super.equals(o) && Util.equalArraysOrNull(this.parameterTypes, ((BinaryMethod)o).parameterTypes);
    }

    public String[] getExceptionTypes() throws JavaModelException {
        if (this.exceptionTypes == null) {
            IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
            char[] genericSignature = info.getGenericSignature();
            if (genericSignature != null) {
                char[] dotBasedSignature = CharOperation.replaceOnCopy(genericSignature, '/', '.');
                this.exceptionTypes = Signature.getThrownExceptionTypes(new String(dotBasedSignature));
            }
            if (this.exceptionTypes == null || this.exceptionTypes.length == 0) {
                char[][] eTypeNames = info.getExceptionTypeNames();
                if (eTypeNames == null || eTypeNames.length == 0) {
                    this.exceptionTypes = NO_TYPES;
                } else {
                    eTypeNames = ClassFile.translatedNames(eTypeNames);
                    this.exceptionTypes = new String[eTypeNames.length];
                    int j = 0;
                    int length = eTypeNames.length;
                    while (j < length) {
                        int nameLength = eTypeNames[j].length;
                        char[] convertedName = new char[nameLength + 2];
                        System.arraycopy(eTypeNames[j], 0, convertedName, 1, nameLength);
                        convertedName[0] = 76;
                        convertedName[nameLength + 1] = 59;
                        this.exceptionTypes[j] = new String(convertedName);
                        ++j;
                    }
                }
            }
        }
        return this.exceptionTypes;
    }

    public int getElementType() {
        return 9;
    }

    public int getFlags() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        return info.getModifiers();
    }

    protected void getHandleMemento(StringBuffer buff) {
        ((JavaElement)this.getParent()).getHandleMemento(buff);
        char delimiter = this.getHandleMementoDelimiter();
        buff.append(delimiter);
        this.escapeMementoName(buff, this.getElementName());
        int i = 0;
        while (i < this.parameterTypes.length) {
            buff.append(delimiter);
            this.escapeMementoName(buff, this.parameterTypes[i]);
            ++i;
        }
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    protected char getHandleMementoDelimiter() {
        return '~';
    }

    public String getKey(boolean forceOpen) throws JavaModelException {
        return this.getKey(this, forceOpen);
    }

    public int getNumberOfParameters() {
        return this.parameterTypes == null ? 0 : this.parameterTypes.length;
    }

    public String[] getParameterNames() throws JavaModelException {
        if (this.parameterNames == null) {
            IType type = (IType)this.getParent();
            SourceMapper mapper = this.getSourceMapper();
            if (mapper != null) {
                char[][] paramNames = mapper.getMethodParameterNames(this);
                if (paramNames == null) {
                    char[] source = mapper.findSource(type);
                    if (source != null) {
                        mapper.mapSource(type, source);
                    }
                    paramNames = mapper.getMethodParameterNames(this);
                }
                if (paramNames != null) {
                    this.parameterNames = new String[paramNames.length];
                    int i = 0;
                    while (i < paramNames.length) {
                        this.parameterNames[i] = new String(paramNames[i]);
                        ++i;
                    }
                }
            }
            if (this.parameterNames == null) {
                IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
                int paramCount = Signature.getParameterCount(new String(info.getMethodDescriptor()));
                this.parameterNames = new String[paramCount];
                int i = 0;
                while (i < paramCount) {
                    this.parameterNames[i] = "arg" + i;
                    ++i;
                }
            }
        }
        return this.parameterNames;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public ITypeParameter getTypeParameter(String typeParameterName) {
        return new TypeParameter(this, typeParameterName);
    }

    public ITypeParameter[] getTypeParameters() throws JavaModelException {
        String[] typeParameterSignatures = this.getTypeParameterSignatures();
        int length = typeParameterSignatures.length;
        if (length == 0) {
            return TypeParameter.NO_TYPE_PARAMETERS;
        }
        ITypeParameter[] typeParameters = new ITypeParameter[length];
        int i = 0;
        while (i < typeParameterSignatures.length) {
            String typeParameterName = Signature.getTypeVariable(typeParameterSignatures[i]);
            typeParameters[i] = new TypeParameter(this, typeParameterName);
            ++i;
        }
        return typeParameters;
    }

    public String[] getTypeParameterSignatures() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        char[] genericSignature = info.getGenericSignature();
        if (genericSignature == null) {
            return CharOperation.NO_STRINGS;
        }
        char[] dotBasedSignature = CharOperation.replaceOnCopy(genericSignature, '/', '.');
        char[][] typeParams = Signature.getTypeParameters(dotBasedSignature);
        return CharOperation.toStrings(typeParams);
    }

    public String getReturnType() throws JavaModelException {
        if (this.returnType == null) {
            IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
            this.returnType = this.getReturnType(info);
        }
        return this.returnType;
    }

    private String getReturnType(IBinaryMethod info) {
        char[] genericSignature = info.getGenericSignature();
        char[] signature = genericSignature == null ? info.getMethodDescriptor() : genericSignature;
        char[] dotBasedSignature = CharOperation.replaceOnCopy(signature, '/', '.');
        String returnTypeName = Signature.getReturnType(new String(dotBasedSignature));
        return new String(ClassFile.translatedName(returnTypeName.toCharArray()));
    }

    public String getSignature() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        return new String(info.getMethodDescriptor());
    }

    public int hashCode() {
        int hash = super.hashCode();
        int i = 0;
        int length = this.parameterTypes.length;
        while (i < length) {
            hash = Util.combineHashCodes(hash, this.parameterTypes[i].hashCode());
            ++i;
        }
        return hash;
    }

    public boolean isConstructor() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        return info.isConstructor();
    }

    public boolean isMainMethod() throws JavaModelException {
        return this.isMainMethod(this);
    }

    public boolean isResolved() {
        return false;
    }

    public boolean isSimilar(IMethod method) {
        return BinaryMethod.areSimilarMethods(this.getElementName(), this.getParameterTypes(), method.getElementName(), method.getParameterTypes(), null);
    }

    public String readableName() {
        int length;
        StringBuffer buffer = new StringBuffer(super.readableName());
        buffer.append("(");
        String[] paramTypes = this.parameterTypes;
        if (paramTypes != null && (length = paramTypes.length) > 0) {
            int i = 0;
            while (i < length) {
                buffer.append(Signature.toString(paramTypes[i]));
                if (i < length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    public JavaElement resolved(Binding binding) {
        ResolvedBinaryMethod resolvedHandle = new ResolvedBinaryMethod(this.parent, this.name, this.parameterTypes, new String(binding.computeUniqueKey()));
        resolvedHandle.occurrenceCount = this.occurrenceCount;
        return resolvedHandle;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            this.toStringName(buffer);
        } else {
            IBinaryMethod methodInfo = (IBinaryMethod)info;
            int flags = methodInfo.getModifiers();
            if (Flags.isStatic(flags)) {
                buffer.append("static ");
            }
            if (!methodInfo.isConstructor()) {
                buffer.append(Signature.toString(this.getReturnType(methodInfo)));
                buffer.append(' ');
            }
            this.toStringName(buffer, flags);
        }
    }

    protected void toStringName(StringBuffer buffer) {
        this.toStringName(buffer, 0);
    }

    protected void toStringName(StringBuffer buffer, int flags) {
        int length;
        buffer.append(this.getElementName());
        buffer.append('(');
        String[] parameters = this.getParameterTypes();
        if (parameters != null && (length = parameters.length) > 0) {
            boolean isVarargs = Flags.isVarargs(flags);
            int i = 0;
            while (i < length) {
                try {
                    if (i < length - 1) {
                        buffer.append(Signature.toString(parameters[i]));
                        buffer.append(", ");
                    } else if (isVarargs) {
                        String parameter = parameters[i].substring(1);
                        buffer.append(Signature.toString(parameter));
                        buffer.append(" ...");
                    } else {
                        buffer.append(Signature.toString(parameters[i]));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    buffer.append("*** invalid signature: ");
                    buffer.append(parameters[i]);
                }
                ++i;
            }
        }
        buffer.append(')');
        if (this.occurrenceCount > 1) {
            buffer.append("#");
            buffer.append(this.occurrenceCount);
        }
    }

    class DecodeParametersNames
    extends SourceElementRequestorAdapter {
        String[] parametersNames;

        DecodeParametersNames() {
        }

        public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
            if (methodInfo.parameterNames != null) {
                int length = methodInfo.parameterNames.length;
                this.parametersNames = new String[length];
                int i = 0;
                while (i < length) {
                    this.parametersNames[i] = new String(methodInfo.parameterNames[i]);
                    ++i;
                }
            }
        }

        public void enterConstructor(ISourceElementRequestor.MethodInfo methodInfo) {
            if (methodInfo.parameterNames != null) {
                int length = methodInfo.parameterNames.length;
                this.parametersNames = new String[length];
                int i = 0;
                while (i < length) {
                    this.parametersNames[i] = new String(methodInfo.parameterNames[i]);
                    ++i;
                }
            }
        }

        public String[] getParametersNames() {
            return this.parametersNames;
        }
    }
}

