/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core.dom.rewrite;

import com.netflix.nebula.lint.jdt.internal.core.dom.rewrite.Indents;
import java.util.ArrayList;
import org.eclipse.text.edits.ISourceModifier;
import org.eclipse.text.edits.ReplaceEdit;

public class SourceModifier
implements ISourceModifier {
    private final String destinationIndent;
    private final int sourceIndentLevel;
    private final int tabWidth;
    private final int indentWidth;

    public SourceModifier(int sourceIndentLevel, String destinationIndent, int tabWidth, int indentWidth) {
        this.destinationIndent = destinationIndent;
        this.sourceIndentLevel = sourceIndentLevel;
        this.tabWidth = tabWidth;
        this.indentWidth = indentWidth;
    }

    public ISourceModifier copy() {
        return this;
    }

    public ReplaceEdit[] getModifications(String source) {
        ArrayList result = new ArrayList();
        int destIndentLevel = Indents.computeIndentUnits(this.destinationIndent, this.tabWidth, this.indentWidth);
        if (destIndentLevel == this.sourceIndentLevel) {
            return result.toArray(new ReplaceEdit[result.size()]);
        }
        return Indents.getChangeIndentEdits(source, this.sourceIndentLevel, this.tabWidth, this.indentWidth, this.destinationIndent);
    }
}

