/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.annotations.Nullable;
import com.netflix.nebula.lint.jgit.api.Git;
import com.netflix.nebula.lint.jgit.api.GitCommand;
import com.netflix.nebula.lint.jgit.api.MergeResult;
import com.netflix.nebula.lint.jgit.api.errors.CheckoutConflictException;
import com.netflix.nebula.lint.jgit.api.errors.ConcurrentRefUpdateException;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.InvalidMergeHeadsException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.api.errors.NoHeadException;
import com.netflix.nebula.lint.jgit.api.errors.NoMessageException;
import com.netflix.nebula.lint.jgit.api.errors.WrongRepositoryStateException;
import com.netflix.nebula.lint.jgit.dircache.DirCacheCheckout;
import com.netflix.nebula.lint.jgit.events.WorkingTreeModifiedEvent;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.Config;
import com.netflix.nebula.lint.jgit.lib.NullProgressMonitor;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectIdRef;
import com.netflix.nebula.lint.jgit.lib.ProgressMonitor;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.RefUpdate;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.merge.MergeConfig;
import com.netflix.nebula.lint.jgit.merge.MergeMessageFormatter;
import com.netflix.nebula.lint.jgit.merge.MergeStrategy;
import com.netflix.nebula.lint.jgit.merge.Merger;
import com.netflix.nebula.lint.jgit.merge.ResolveMerger;
import com.netflix.nebula.lint.jgit.merge.SquashMessageFormatter;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import com.netflix.nebula.lint.jgit.revwalk.RevWalkUtils;
import com.netflix.nebula.lint.jgit.treewalk.FileTreeIterator;
import com.netflix.nebula.lint.jgit.util.StringUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MergeCommand
extends GitCommand<MergeResult> {
    private MergeStrategy mergeStrategy = MergeStrategy.RECURSIVE;
    private List<Ref> commits = new LinkedList<Ref>();
    private Boolean squash;
    private FastForwardMode fastForwardMode;
    private String message;
    private boolean insertChangeId;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private Boolean commit;

    protected MergeCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MergeResult call() throws GitAPIException, NoHeadException, ConcurrentRefUpdateException, CheckoutConflictException, InvalidMergeHeadsException, WrongRepositoryStateException, NoMessageException {
        this.checkCallable();
        this.fallBackToConfiguration();
        this.checkParameters();
        DirCacheCheckout dco = null;
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try {
                MergeResult mergeResult;
                RevWalk revWalk = new RevWalk(this.repo);
                try {
                    boolean noProblems;
                    Ref head = this.repo.exactRef("HEAD");
                    if (head == null) {
                        throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                    }
                    StringBuilder refLogMessage = new StringBuilder("merge ");
                    Ref ref = this.commits.get(0);
                    refLogMessage.append(ref.getName());
                    ref = this.repo.getRefDatabase().peel(ref);
                    ObjectId objectId = ref.getPeeledObjectId();
                    if (objectId == null) {
                        objectId = ref.getObjectId();
                    }
                    RevCommit srcCommit = revWalk.lookupCommit(objectId);
                    ObjectId headId = head.getObjectId();
                    if (headId == null) {
                        revWalk.parseHeaders(srcCommit);
                        dco = new DirCacheCheckout(this.repo, this.repo.lockDirCache(), srcCommit.getTree());
                        dco.setFailOnConflict(true);
                        dco.setProgressMonitor(this.monitor);
                        dco.checkout();
                        RefUpdate refUpdate = this.repo.updateRef(head.getTarget().getName());
                        refUpdate.setNewObjectId(objectId);
                        refUpdate.setExpectedOldObjectId(null);
                        refUpdate.setRefLogMessage("initial pull", false);
                        if (refUpdate.update() != RefUpdate.Result.NEW) {
                            throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                        }
                        this.setCallable(false);
                        ObjectId[] objectIdArray = new ObjectId[2];
                        objectIdArray[1] = srcCommit;
                        mergeResult = new MergeResult(srcCommit, srcCommit, objectIdArray, MergeResult.MergeStatus.FAST_FORWARD, this.mergeStrategy, null, null);
                        return mergeResult;
                    }
                    RevCommit headCommit = revWalk.lookupCommit(headId);
                    if (revWalk.isMergedInto(srcCommit, headCommit)) {
                        this.setCallable(false);
                        ObjectId[] objectIdArray = new ObjectId[]{headCommit, srcCommit};
                        return new MergeResult(headCommit, srcCommit, objectIdArray, MergeResult.MergeStatus.ALREADY_UP_TO_DATE, this.mergeStrategy, null, null);
                    }
                    if (revWalk.isMergedInto(headCommit, srcCommit) && this.fastForwardMode != FastForwardMode.NO_FF) {
                        ObjectId newHead;
                        refLogMessage.append(": " + (Object)((Object)MergeResult.MergeStatus.FAST_FORWARD));
                        dco = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), srcCommit.getTree());
                        dco.setProgressMonitor(this.monitor);
                        dco.setFailOnConflict(true);
                        dco.checkout();
                        String msg = null;
                        ObjectId base = null;
                        MergeResult.MergeStatus mergeStatus = null;
                        if (!this.squash.booleanValue()) {
                            this.updateHead(refLogMessage, srcCommit, headId);
                            newHead = base = srcCommit;
                            mergeStatus = MergeResult.MergeStatus.FAST_FORWARD;
                        } else {
                            msg = JGitText.get().squashCommitNotUpdatingHEAD;
                            newHead = base = headId;
                            mergeStatus = MergeResult.MergeStatus.FAST_FORWARD_SQUASHED;
                            List<RevCommit> squashedCommits = RevWalkUtils.find(revWalk, srcCommit, headCommit);
                            String squashMessage = new SquashMessageFormatter().format(squashedCommits, head);
                            this.repo.writeSquashCommitMsg(squashMessage);
                        }
                        this.setCallable(false);
                        ObjectId[] objectIdArray = new ObjectId[]{headCommit, srcCommit};
                        return new MergeResult(newHead, base, objectIdArray, mergeStatus, this.mergeStrategy, null, msg);
                    }
                    if (this.fastForwardMode == FastForwardMode.FF_ONLY) {
                        ObjectId[] objectIdArray = new ObjectId[]{headCommit, srcCommit};
                        return new MergeResult(headCommit, srcCommit, objectIdArray, MergeResult.MergeStatus.ABORTED, this.mergeStrategy, null, null);
                    }
                    String mergeMessage = "";
                    if (!this.squash.booleanValue()) {
                        mergeMessage = this.message != null ? this.message : new MergeMessageFormatter().format(this.commits, head);
                        this.repo.writeMergeCommitMsg(mergeMessage);
                        this.repo.writeMergeHeads(Arrays.asList(ref.getObjectId()));
                    } else {
                        List<RevCommit> squashedCommits = RevWalkUtils.find(revWalk, srcCommit, headCommit);
                        String squashMessage = new SquashMessageFormatter().format(squashedCommits, head);
                        this.repo.writeSquashCommitMsg(squashMessage);
                    }
                    Merger merger = this.mergeStrategy.newMerger(this.repo);
                    merger.setProgressMonitor(this.monitor);
                    Map<String, com.netflix.nebula.lint.jgit.merge.MergeResult<?>> lowLevelResults = null;
                    Map<String, ResolveMerger.MergeFailureReason> failingPaths = null;
                    List<String> unmergedPaths = null;
                    if (merger instanceof ResolveMerger) {
                        ResolveMerger resolveMerger = (ResolveMerger)merger;
                        resolveMerger.setCommitNames(new String[]{"BASE", "HEAD", ref.getName()});
                        resolveMerger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                        noProblems = merger.merge(headCommit, srcCommit);
                        lowLevelResults = resolveMerger.getMergeResults();
                        failingPaths = resolveMerger.getFailingPaths();
                        unmergedPaths = resolveMerger.getUnmergedPaths();
                        if (!resolveMerger.getModifiedFiles().isEmpty()) {
                            this.repo.fireEvent(new WorkingTreeModifiedEvent(resolveMerger.getModifiedFiles(), null));
                        }
                    } else {
                        noProblems = merger.merge(headCommit, srcCommit);
                    }
                    refLogMessage.append(": Merge made by ");
                    if (!revWalk.isMergedInto(headCommit, srcCommit)) {
                        refLogMessage.append(this.mergeStrategy.getName());
                    } else {
                        refLogMessage.append("recursive");
                    }
                    refLogMessage.append('.');
                    if (noProblems) {
                        dco = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                        dco.setFailOnConflict(true);
                        dco.setProgressMonitor(this.monitor);
                        dco.checkout();
                        String msg = null;
                        ObjectId newHeadId = null;
                        MergeResult.MergeStatus mergeStatus = null;
                        if (!this.commit.booleanValue() && this.squash.booleanValue()) {
                            mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED_NOT_COMMITTED;
                        }
                        if (!this.commit.booleanValue() && !this.squash.booleanValue()) {
                            mergeStatus = MergeResult.MergeStatus.MERGED_NOT_COMMITTED;
                        }
                        if (this.commit.booleanValue() && !this.squash.booleanValue()) {
                            Throwable throwable2 = null;
                            Object var22_36 = null;
                            try (Git git = new Git(this.getRepository());){
                                newHeadId = git.commit().setReflogComment(refLogMessage.toString()).setInsertChangeId(this.insertChangeId).call().getId();
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                    throw throwable2;
                                }
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                                throw throwable2;
                            }
                            mergeStatus = MergeResult.MergeStatus.MERGED;
                            this.getRepository().autoGC(this.monitor);
                        }
                        if (this.commit.booleanValue() && this.squash.booleanValue()) {
                            msg = JGitText.get().squashCommitNotUpdatingHEAD;
                            newHeadId = headCommit.getId();
                            mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED;
                        }
                        ObjectId[] objectIdArray = new ObjectId[]{headCommit.getId(), srcCommit.getId()};
                        return new MergeResult(newHeadId, null, objectIdArray, mergeStatus, this.mergeStrategy, null, msg);
                    }
                    if (failingPaths != null) {
                        this.repo.writeMergeCommitMsg(null);
                        this.repo.writeMergeHeads(null);
                        ObjectId[] objectIdArray = new ObjectId[]{headCommit.getId(), srcCommit.getId()};
                        return new MergeResult(null, merger.getBaseCommitId(), objectIdArray, MergeResult.MergeStatus.FAILED, this.mergeStrategy, lowLevelResults, failingPaths, null);
                    }
                    String mergeMessageWithConflicts = new MergeMessageFormatter().formatWithConflicts(mergeMessage, unmergedPaths);
                    this.repo.writeMergeCommitMsg(mergeMessageWithConflicts);
                    return new MergeResult(null, merger.getBaseCommitId(), new ObjectId[]{headCommit.getId(), srcCommit.getId()}, MergeResult.MergeStatus.CONFLICTING, this.mergeStrategy, lowLevelResults, null);
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (revWalk == null) return mergeResult;
                    revWalk.close();
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (com.netflix.nebula.lint.jgit.errors.CheckoutConflictException e) {
            List<String> conflicts = dco == null ? Collections.emptyList() : dco.getConflicts();
            throw new CheckoutConflictException(conflicts, e);
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfMergeCommand, e), e);
        }
    }

    private void checkParameters() throws InvalidMergeHeadsException {
        if (this.squash.booleanValue() && this.fastForwardMode == FastForwardMode.NO_FF) {
            throw new JGitInternalException(JGitText.get().cannotCombineSquashWithNoff);
        }
        if (this.commits.size() != 1) {
            throw new InvalidMergeHeadsException(this.commits.isEmpty() ? JGitText.get().noMergeHeadSpecified : MessageFormat.format(JGitText.get().mergeStrategyDoesNotSupportHeads, this.mergeStrategy.getName(), this.commits.size()));
        }
    }

    private void fallBackToConfiguration() {
        MergeConfig config = MergeConfig.getConfigForCurrentBranch(this.repo);
        if (this.squash == null) {
            this.squash = config.isSquash();
        }
        if (this.commit == null) {
            this.commit = config.isCommit();
        }
        if (this.fastForwardMode == null) {
            this.fastForwardMode = config.getFastForwardMode();
        }
    }

    private void updateHead(StringBuilder refLogMessage, ObjectId newHeadId, ObjectId oldHeadID) throws IOException, ConcurrentRefUpdateException {
        RefUpdate refUpdate = this.repo.updateRef("HEAD");
        refUpdate.setNewObjectId(newHeadId);
        refUpdate.setRefLogMessage(refLogMessage.toString(), false);
        refUpdate.setExpectedOldObjectId(oldHeadID);
        RefUpdate.Result rc = refUpdate.update();
        switch (rc) {
            case NEW: 
            case FAST_FORWARD: {
                return;
            }
            case LOCK_FAILURE: 
            case REJECTED: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, refUpdate.getRef(), rc);
            }
        }
        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"HEAD", newHeadId.toString(), rc}));
    }

    public MergeCommand setStrategy(MergeStrategy mergeStrategy) {
        this.checkCallable();
        this.mergeStrategy = mergeStrategy;
        return this;
    }

    public MergeCommand include(Ref aCommit) {
        this.checkCallable();
        this.commits.add(aCommit);
        return this;
    }

    public MergeCommand include(AnyObjectId aCommit) {
        return this.include(aCommit.getName(), aCommit);
    }

    public MergeCommand include(String name, AnyObjectId aCommit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, aCommit.copy()));
    }

    public MergeCommand setSquash(boolean squash) {
        this.checkCallable();
        this.squash = squash;
        return this;
    }

    public MergeCommand setFastForward(@Nullable FastForwardMode fastForwardMode) {
        this.checkCallable();
        this.fastForwardMode = fastForwardMode;
        return this;
    }

    public MergeCommand setCommit(boolean commit) {
        this.commit = commit;
        return this;
    }

    public MergeCommand setMessage(String message) {
        this.message = message;
        return this;
    }

    public MergeCommand setInsertChangeId(boolean insertChangeId) {
        this.checkCallable();
        this.insertChangeId = insertChangeId;
        return this;
    }

    public MergeCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    public static enum FastForwardMode implements Config.ConfigEnum
    {
        FF,
        NO_FF,
        FF_ONLY;


        @Override
        public String toConfigValue() {
            return "--" + this.name().toLowerCase(Locale.ROOT).replace('_', '-');
        }

        @Override
        public boolean matchConfigValue(String in) {
            if (StringUtils.isEmptyOrNull(in)) {
                return false;
            }
            if (!in.startsWith("--")) {
                return false;
            }
            return this.name().equalsIgnoreCase(in.substring(2).replace('-', '_'));
        }

        public static FastForwardMode valueOf(String string) {
            return Enum.valueOf(FastForwardMode.class, string);
        }

        public static enum Merge {
            TRUE,
            FALSE,
            ONLY;


            public static Merge valueOf(String string) {
                return Enum.valueOf(Merge.class, string);
            }
        }
    }
}

