/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.rule.dependency.provider;

import com.netflix.nebula.lint.rule.dependency.provider.AbstractRecommendationProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.specs.Specs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClasspathBasedRecommendationProvider
extends AbstractRecommendationProvider {
    private final Logger log = LoggerFactory.getLogger(ClasspathBasedRecommendationProvider.class);
    protected Project project;

    ClasspathBasedRecommendationProvider(Project project) {
        this.project = project;
    }

    Set<File> getBomsOnConfiguration() {
        LinkedHashSet<File> boms = new LinkedHashSet<File>();
        ConfigurationContainer allConfigurations = this.project.getConfigurations();
        for (Configuration configuration : allConfigurations) {
            Dependency dep;
            DependencySet allDependencies = configuration.getAllDependencies();
            Iterator iterator = allDependencies.iterator();
            while (iterator.hasNext() && !this.dependencyIsAlreadyAdded(dep = (Dependency)iterator.next(), boms)) {
                Configuration bomConf = this.project.getConfigurations().detachedConfiguration(new Dependency[]{this.project.getDependencies().create((Object)(dep.getGroup() + ":" + dep.getName() + ":" + dep.getVersion() + "@pom"))});
                Set files = bomConf.getResolvedConfiguration().getLenientConfiguration().getFiles(Specs.SATISFIES_ALL);
                for (File file : files) {
                    if (!this.shouldAddToBoms(file)) continue;
                    boms.add(file);
                }
            }
        }
        return boms;
    }

    boolean shouldAddToBoms(File file) {
        boolean isAPom = file.getName().endsWith(".pom");
        String fileContents = "";
        try {
            fileContents = new String(Files.readAllBytes(Paths.get(file.toURI())));
        }
        catch (IOException e) {
            this.log.info("Problem when parsing file %s", (Object)file.toString(), (Object)e);
        }
        boolean packagingIsPom = fileContents.toLowerCase().contains("<packaging>pom</packaging>");
        return isAPom && packagingIsPom;
    }

    boolean dependencyIsAlreadyAdded(Dependency dep, Set<File> boms) {
        for (File bom : boms) {
            String dependencyAsFilePath = dep.getGroup() + File.separator + dep.getName() + File.separator + dep.getVersion();
            if (!bom.toString().contains(dependencyAsFilePath)) continue;
            return true;
        }
        return false;
    }
}

