/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core.search.matching;

import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.core.search.SearchPattern;
import com.netflix.nebula.lint.jdt.internal.core.index.EntryResult;
import com.netflix.nebula.lint.jdt.internal.core.index.Index;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.IIndexConstants;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.JavaSearchPattern;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.QualifiedTypeDeclarationPattern;
import java.io.IOException;

public class MultiTypeDeclarationPattern
extends JavaSearchPattern
implements IIndexConstants {
    public char[][] simpleNames;
    public char[][] qualifications;
    public char typeSuffix;
    protected static char[][] CATEGORIES = new char[][]{TYPE_DECL};

    public MultiTypeDeclarationPattern(char[][] qualifications, char[][] simpleNames, char typeSuffix, int matchRule) {
        this(matchRule);
        int i;
        int length;
        if (this.isCaseSensitive() || qualifications == null) {
            this.qualifications = qualifications;
        } else {
            length = qualifications.length;
            this.qualifications = new char[length][];
            i = 0;
            while (i < length) {
                this.qualifications[i] = CharOperation.toLowerCase(qualifications[i]);
                ++i;
            }
        }
        if (simpleNames == null) {
            this.simpleNames = CharOperation.NO_CHAR_CHAR;
        } else if (this.isCaseSensitive()) {
            this.simpleNames = simpleNames;
        } else {
            length = simpleNames.length;
            this.simpleNames = new char[length][];
            i = 0;
            while (i < length) {
                this.simpleNames[i] = CharOperation.toLowerCase(simpleNames[i]);
                ++i;
            }
        }
        this.typeSuffix = typeSuffix;
        this.mustResolve = typeSuffix != '\u0000';
    }

    MultiTypeDeclarationPattern(int matchRule) {
        super(8, matchRule);
    }

    public SearchPattern getBlankPattern() {
        return new QualifiedTypeDeclarationPattern(8);
    }

    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        int max;
        int count;
        QualifiedTypeDeclarationPattern pattern = (QualifiedTypeDeclarationPattern)decodedPattern;
        block0 : switch (this.typeSuffix) {
            case 'C': {
                switch (pattern.typeSuffix) {
                    case '\t': 
                    case '\n': 
                    case 'C': {
                        break block0;
                    }
                }
                return false;
            }
            case 'I': {
                switch (pattern.typeSuffix) {
                    case '\n': 
                    case 'I': {
                        break block0;
                    }
                }
                return false;
            }
            case 'E': {
                switch (pattern.typeSuffix) {
                    case '\t': 
                    case 'E': {
                        break block0;
                    }
                }
                return false;
            }
            case 'A': {
                if (this.typeSuffix == pattern.typeSuffix) break;
                return false;
            }
            case '\n': {
                switch (pattern.typeSuffix) {
                    case '\n': 
                    case 'C': 
                    case 'I': {
                        break block0;
                    }
                }
                return false;
            }
            case '\t': {
                switch (pattern.typeSuffix) {
                    case '\t': 
                    case 'C': 
                    case 'E': {
                        break block0;
                    }
                }
                return false;
            }
        }
        if (this.qualifications != null) {
            count = 0;
            max = this.qualifications.length;
            while (count < max) {
                if (this.matchesName(this.qualifications[count], pattern.qualification)) break;
                ++count;
            }
            if (count == max) {
                return false;
            }
        }
        count = 0;
        max = this.simpleNames.length;
        while (count < max) {
            if (this.matchesName(this.simpleNames[count], pattern.simpleName)) break;
            ++count;
        }
        return count < max;
    }

    EntryResult[] queryIn(Index index) throws IOException {
        int count = -1;
        int numOfNames = this.simpleNames.length;
        EntryResult[][] allResults = numOfNames > 1 ? new EntryResult[numOfNames][] : null;
        int i = 0;
        while (i < numOfNames) {
            char[] key = this.simpleNames[i];
            int matchRule = this.getMatchRule();
            switch (this.getMatchMode()) {
                case 1: {
                    break;
                }
                case 0: {
                    matchRule = matchRule - 0 + 1;
                    key = CharOperation.append(key, '/');
                    break;
                }
                case 2: {
                    if (key[key.length - 1] == '*') break;
                    key = CharOperation.concat(key, ONE_STAR, '/');
                }
            }
            EntryResult[] entries = index.query(this.getIndexCategories(), key, matchRule);
            if (entries != null) {
                if (allResults == null) {
                    return entries;
                }
                allResults[++count] = entries;
            }
            ++i;
        }
        if (count == -1) {
            return null;
        }
        int total = 0;
        int i2 = 0;
        while (i2 <= count) {
            total += allResults[i2].length;
            ++i2;
        }
        EntryResult[] allEntries = new EntryResult[total];
        int next = 0;
        int i3 = 0;
        while (i3 <= count) {
            EntryResult[] entries = allResults[i3];
            System.arraycopy(entries, 0, allEntries, next, entries.length);
            next += entries.length;
            ++i3;
        }
        return allEntries;
    }

    protected StringBuffer print(StringBuffer output) {
        int i;
        switch (this.typeSuffix) {
            case 'C': {
                output.append("MultiClassDeclarationPattern: ");
                break;
            }
            case '\n': {
                output.append("MultiClassAndInterfaceDeclarationPattern: ");
                break;
            }
            case '\t': {
                output.append("MultiClassAndEnumDeclarationPattern: ");
                break;
            }
            case 'I': {
                output.append("MultiInterfaceDeclarationPattern: ");
                break;
            }
            case 'E': {
                output.append("MultiEnumDeclarationPattern: ");
                break;
            }
            case 'A': {
                output.append("MultiAnnotationTypeDeclarationPattern: ");
                break;
            }
            default: {
                output.append("MultiTypeDeclarationPattern: ");
            }
        }
        if (this.qualifications != null) {
            output.append("qualifications: <");
            i = 0;
            while (i < this.qualifications.length) {
                output.append(this.qualifications[i]);
                if (i < this.qualifications.length - 1) {
                    output.append(", ");
                }
                ++i;
            }
            output.append("> ");
        }
        if (this.simpleNames != null) {
            output.append("simpleNames: <");
            i = 0;
            while (i < this.simpleNames.length) {
                output.append(this.simpleNames[i]);
                if (i < this.simpleNames.length - 1) {
                    output.append(", ");
                }
                ++i;
            }
            output.append(">");
        }
        return super.print(output);
    }
}

