/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.transport;

import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.transport.InsecureCipherFactory;
import com.netflix.nebula.lint.jgit.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

abstract class WalkEncryption {
    static final WalkEncryption NONE = new NoEncryption();
    static final String JETS3T_CRYPTO_VER = "jets3t-crypto-ver";
    static final String JETS3T_CRYPTO_ALG = "jets3t-crypto-alg";

    WalkEncryption() {
    }

    abstract OutputStream encrypt(OutputStream var1) throws IOException;

    abstract void request(HttpURLConnection var1, String var2) throws IOException;

    abstract void validate(HttpURLConnection var1, String var2) throws IOException;

    abstract InputStream decrypt(InputStream var1) throws IOException;

    protected void validateImpl(HttpURLConnection u, String prefix, String version, String name) throws IOException {
        String v = u.getHeaderField(String.valueOf(prefix) + JETS3T_CRYPTO_VER);
        if (v == null) {
            v = "";
        }
        if (!version.equals(v)) {
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedEncryptionVersion, v));
        }
        v = u.getHeaderField(String.valueOf(prefix) + JETS3T_CRYPTO_ALG);
        if (v == null) {
            v = "";
        }
        if (!name.equalsIgnoreCase(v)) {
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedEncryptionAlgorithm, v));
        }
    }

    IOException error(Throwable why) {
        return new IOException(MessageFormat.format(JGitText.get().encryptionError, why.getMessage()), why);
    }

    static GeneralSecurityException securityError(String message) {
        return new GeneralSecurityException(MessageFormat.format(JGitText.get().encryptionError, message));
    }

    static WalkEncryption instance(Properties props) throws GeneralSecurityException {
        String algo = props.getProperty("crypto.algorithm", "PBEWithMD5AndDES");
        String vers = props.getProperty("crypto.version", "0");
        String pass = props.getProperty("password");
        if (pass == null) {
            return NONE;
        }
        switch (vers) {
            case "0": {
                return new JetS3tV2(algo, pass);
            }
            case "1": {
                return new JGitV1(algo, pass);
            }
            case "2": {
                return new JGitV2(props);
            }
        }
        throw new GeneralSecurityException(MessageFormat.format(JGitText.get().unsupportedEncryptionVersion, vers));
    }

    static class JGitV1
    extends SymmetricEncryption {
        static final String VERSION = "1";

        static Properties wrap(String algo, String pass) {
            Properties props = new Properties();
            props.put("crypto.algorithm", algo);
            props.put("crypto.version", VERSION);
            props.put("password", pass);
            props.put(String.valueOf(algo) + ".algo", algo);
            props.put(String.valueOf(algo) + ".key.algo", algo);
            props.put(String.valueOf(algo) + ".key.iter", DEFAULT_KEY_ITER);
            props.put(String.valueOf(algo) + ".key.size", DEFAULT_KEY_SIZE);
            props.put(String.valueOf(algo) + ".key.salt", DEFAULT_KEY_SALT);
            return props;
        }

        JGitV1(String algo, String pass) throws GeneralSecurityException {
            super(JGitV1.wrap(algo, pass));
            String name = this.cipherAlgo.toUpperCase(Locale.ROOT);
            Matcher matcherPBE = Pattern.compile("(PBE).*(WITH).+(AND).+").matcher(name);
            if (!matcherPBE.matches()) {
                throw new GeneralSecurityException(JGitText.get().encryptionOnlyPBE);
            }
        }
    }

    static class JGitV2
    extends SymmetricEncryption {
        static final String VERSION = "2";

        JGitV2(Properties props) throws GeneralSecurityException {
            super(props);
        }
    }

    static class JetS3tV2
    extends WalkEncryption {
        static final String VERSION = "2";
        static final String ALGORITHM = "PBEWithMD5AndDES";
        static final int ITERATIONS = 5000;
        static final int KEY_SIZE = 32;
        static final byte[] SALT = new byte[]{-92, 11, -56, 52, -42, -107, -13, 19};
        static final byte[] ZERO_AES_IV = new byte[16];
        private static final String CRYPTO_VER = "2";
        private final String cryptoAlg;
        private final SecretKey secretKey;
        private final AlgorithmParameterSpec paramSpec;

        JetS3tV2(String algo, String key) throws GeneralSecurityException {
            this.cryptoAlg = algo;
            Cipher cipher = InsecureCipherFactory.create(this.cryptoAlg);
            String cryptoName = this.cryptoAlg.toUpperCase(Locale.ROOT);
            if (!cryptoName.startsWith("PBE")) {
                throw new GeneralSecurityException(JGitText.get().encryptionOnlyPBE);
            }
            PBEKeySpec keySpec = new PBEKeySpec(key.toCharArray(), SALT, 5000, 32);
            this.secretKey = SecretKeyFactory.getInstance(algo).generateSecret(keySpec);
            boolean useIV = cryptoName.contains("AES");
            if (useIV) {
                IvParameterSpec paramIV = new IvParameterSpec(ZERO_AES_IV);
                this.paramSpec = new PBEParameterSpec(SALT, 5000, paramIV);
            } else {
                this.paramSpec = new PBEParameterSpec(SALT, 5000);
            }
            cipher.init(1, (Key)this.secretKey, this.paramSpec);
            cipher.doFinal();
        }

        @Override
        void request(HttpURLConnection u, String prefix) {
            u.setRequestProperty(String.valueOf(prefix) + WalkEncryption.JETS3T_CRYPTO_VER, "2");
            u.setRequestProperty(String.valueOf(prefix) + WalkEncryption.JETS3T_CRYPTO_ALG, this.cryptoAlg);
        }

        @Override
        void validate(HttpURLConnection u, String prefix) throws IOException {
            this.validateImpl(u, prefix, "2", this.cryptoAlg);
        }

        @Override
        OutputStream encrypt(OutputStream os) throws IOException {
            try {
                Cipher cipher = InsecureCipherFactory.create(this.cryptoAlg);
                cipher.init(1, (Key)this.secretKey, this.paramSpec);
                return new CipherOutputStream(os, cipher);
            }
            catch (GeneralSecurityException e) {
                throw this.error(e);
            }
        }

        @Override
        InputStream decrypt(InputStream in) throws IOException {
            try {
                Cipher cipher = InsecureCipherFactory.create(this.cryptoAlg);
                cipher.init(2, (Key)this.secretKey, this.paramSpec);
                return new CipherInputStream(in, cipher);
            }
            catch (GeneralSecurityException e) {
                throw this.error(e);
            }
        }
    }

    static interface Keys {
        public static final String JGIT_PROFILE = "jgit-crypto-profile";
        public static final String JGIT_VERSION = "jgit-crypto-version";
        public static final String JGIT_CONTEXT = "jgit-crypto-context";
        public static final String X_ALGO = ".algo";
        public static final String X_KEY_ALGO = ".key.algo";
        public static final String X_KEY_SIZE = ".key.size";
        public static final String X_KEY_ITER = ".key.iter";
        public static final String X_KEY_SALT = ".key.salt";
    }

    private static class NoEncryption
    extends WalkEncryption {
        private NoEncryption() {
        }

        @Override
        void request(HttpURLConnection u, String prefix) {
        }

        @Override
        void validate(HttpURLConnection u, String prefix) throws IOException {
            this.validateImpl(u, prefix, "", "");
        }

        @Override
        InputStream decrypt(InputStream in) {
            return in;
        }

        @Override
        OutputStream encrypt(OutputStream os) {
            return os;
        }
    }

    static abstract class SymmetricEncryption
    extends WalkEncryption
    implements Keys,
    Vals {
        final String profile;
        final String version;
        final String cipherAlgo;
        final String paramsAlgo;
        final SecretKey secretKey;
        volatile String context;
        volatile Cipher decryptCipher;

        SymmetricEncryption(Properties props) throws GeneralSecurityException {
            byte[] salt;
            int iter;
            int size;
            this.profile = props.getProperty("crypto.algorithm");
            this.version = props.getProperty("crypto.version");
            String pass = props.getProperty("password");
            this.cipherAlgo = props.getProperty(String.valueOf(this.profile) + ".algo", "PBEWithMD5AndDES");
            String keyAlgo = props.getProperty(String.valueOf(this.profile) + ".key.algo", "PBEWithMD5AndDES");
            String keySize = props.getProperty(String.valueOf(this.profile) + ".key.size", DEFAULT_KEY_SIZE);
            String keyIter = props.getProperty(String.valueOf(this.profile) + ".key.iter", DEFAULT_KEY_ITER);
            String keySalt = props.getProperty(String.valueOf(this.profile) + ".key.salt", DEFAULT_KEY_SALT);
            Cipher cipher = InsecureCipherFactory.create(this.cipherAlgo);
            SecretKeyFactory factory = SecretKeyFactory.getInstance(keyAlgo);
            try {
                size = Integer.parseInt(keySize);
            }
            catch (Exception e) {
                throw SymmetricEncryption.securityError(".key.size" + keySize);
            }
            try {
                iter = Integer.parseInt(keyIter);
            }
            catch (Exception e) {
                throw SymmetricEncryption.securityError(".key.iter" + keyIter);
            }
            try {
                salt = DatatypeConverter.parseHexBinary((String)keySalt.replaceAll("\\s+", ""));
            }
            catch (Exception e) {
                throw SymmetricEncryption.securityError(".key.salt" + keySalt);
            }
            PBEKeySpec keySpec = new PBEKeySpec(pass.toCharArray(), salt, iter, size);
            SecretKey keyBase = factory.generateSecret(keySpec);
            String name = this.cipherAlgo.toUpperCase(Locale.ROOT);
            Matcher matcherPBE = Pattern.compile("(PBE).*(WITH).+(AND).+").matcher(name);
            Matcher matcherTrans = Pattern.compile("(.+)/(.+)/(.+)").matcher(name);
            if (matcherPBE.matches()) {
                this.paramsAlgo = this.cipherAlgo;
                this.secretKey = keyBase;
            } else if (matcherTrans.find()) {
                this.paramsAlgo = matcherTrans.group(1);
                this.secretKey = new SecretKeySpec(keyBase.getEncoded(), this.paramsAlgo);
            } else {
                throw new GeneralSecurityException(MessageFormat.format(JGitText.get().unsupportedEncryptionAlgorithm, this.cipherAlgo));
            }
            cipher.init(1, this.secretKey);
            cipher.doFinal();
        }

        @Override
        OutputStream encrypt(OutputStream output) throws IOException {
            try {
                Cipher cipher = InsecureCipherFactory.create(this.cipherAlgo);
                cipher.init(1, this.secretKey);
                AlgorithmParameters params = cipher.getParameters();
                this.context = params == null ? "" : Base64.encodeBytes(params.getEncoded());
                return new CipherOutputStream(output, cipher);
            }
            catch (Exception e) {
                throw this.error(e);
            }
        }

        @Override
        void request(HttpURLConnection conn, String prefix) throws IOException {
            conn.setRequestProperty(String.valueOf(prefix) + "jgit-crypto-profile", this.profile);
            conn.setRequestProperty(String.valueOf(prefix) + "jgit-crypto-version", this.version);
            conn.setRequestProperty(String.valueOf(prefix) + "jgit-crypto-context", this.context);
        }

        @Override
        void validate(HttpURLConnection conn, String prefix) throws IOException {
            String prof = conn.getHeaderField(String.valueOf(prefix) + "jgit-crypto-profile");
            String vers = conn.getHeaderField(String.valueOf(prefix) + "jgit-crypto-version");
            String cont = conn.getHeaderField(String.valueOf(prefix) + "jgit-crypto-context");
            if (prof == null) {
                throw new IOException(MessageFormat.format(JGitText.get().encryptionError, "jgit-crypto-profile"));
            }
            if (vers == null) {
                throw new IOException(MessageFormat.format(JGitText.get().encryptionError, "jgit-crypto-version"));
            }
            if (cont == null) {
                throw new IOException(MessageFormat.format(JGitText.get().encryptionError, "jgit-crypto-context"));
            }
            if (!this.profile.equals(prof)) {
                throw new IOException(MessageFormat.format(JGitText.get().unsupportedEncryptionAlgorithm, prof));
            }
            if (!this.version.equals(vers)) {
                throw new IOException(MessageFormat.format(JGitText.get().unsupportedEncryptionVersion, vers));
            }
            try {
                this.decryptCipher = InsecureCipherFactory.create(this.cipherAlgo);
                if (cont.isEmpty()) {
                    this.decryptCipher.init(2, this.secretKey);
                } else {
                    AlgorithmParameters params = AlgorithmParameters.getInstance(this.paramsAlgo);
                    params.init(Base64.decode(cont));
                    this.decryptCipher.init(2, (Key)this.secretKey, params);
                }
            }
            catch (Exception e) {
                throw this.error(e);
            }
        }

        @Override
        InputStream decrypt(InputStream input) throws IOException {
            try {
                CipherInputStream cipherInputStream = new CipherInputStream(input, this.decryptCipher);
                return cipherInputStream;
            }
            finally {
                this.decryptCipher = null;
            }
        }
    }

    static interface Vals {
        public static final String DEFAULT_VERS = "0";
        public static final String DEFAULT_ALGO = "PBEWithMD5AndDES";
        public static final String DEFAULT_KEY_ALGO = "PBEWithMD5AndDES";
        public static final String DEFAULT_KEY_SIZE = Integer.toString(32);
        public static final String DEFAULT_KEY_ITER = Integer.toString(5000);
        public static final String DEFAULT_KEY_SALT = DatatypeConverter.printHexBinary((byte[])JetS3tV2.SALT);
        public static final String EMPTY = "";
        public static final String REGEX_WS = "\\s+";
        public static final String REGEX_PBE = "(PBE).*(WITH).+(AND).+";
        public static final String REGEX_TRANS = "(.+)/(.+)/(.+)";
    }
}

