/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.org.codenarc.rule;

import com.netflix.nebula.lint.org.codenarc.rule.Rule;
import com.netflix.nebula.lint.org.codenarc.rule.Violation;
import com.netflix.nebula.lint.org.codenarc.source.SourceCode;
import com.netflix.nebula.lint.org.codenarc.source.SourceCodeCriteria;
import com.netflix.nebula.lint.org.codenarc.util.ImportUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ImportNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRule
implements Rule {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRule.class);
    private boolean enabled = true;
    private String applyToFilesMatching;
    private String doNotApplyToFilesMatching;
    private String applyToFileNames;
    private String doNotApplyToFileNames;
    private String violationMessage;
    private String description;

    @Override
    public abstract String getName();

    public abstract void setName(String var1);

    @Override
    public abstract int getPriority();

    public abstract void setPriority(int var1);

    @Override
    public int getCompilerPhase() {
        return 3;
    }

    public abstract void applyTo(SourceCode var1, List<Violation> var2);

    @Override
    public List<Violation> applyTo(SourceCode sourceCode) throws Throwable {
        try {
            this.validateAstCompilerPhase(sourceCode);
            this.validate();
            ArrayList<Violation> violations = new ArrayList<Violation>();
            if (this.shouldApplyThisRuleTo(sourceCode)) {
                this.applyTo(sourceCode, violations);
            }
            this.overrideViolationMessageIfNecessary(violations);
            return violations;
        }
        catch (Throwable t) {
            LOG.error("Error from [" + this.getClass().getName() + "] processing source file [" + sourceCode.getPath() + "]", t);
            throw t;
        }
    }

    private void validateAstCompilerPhase(SourceCode sourceCode) {
        if (sourceCode.getAstCompilerPhase() != this.getCompilerPhase()) {
            throw new IllegalArgumentException("This rule requires SourceCode with AST compiler phase '" + this.getCompilerPhase() + "', but was handed one with AST compiler phase '" + sourceCode.getAstCompilerPhase() + "'");
        }
    }

    public boolean isReady() {
        return true;
    }

    public void validate() {
    }

    public String toString() {
        return String.format("%s[name=%s, priority=%s]", this.getClassNameNoPackage(), this.getName(), this.getPriority());
    }

    protected Violation createViolation(Integer lineNumber, String sourceLine, String message) {
        Violation violation = new Violation();
        violation.setRule(this);
        violation.setSourceLine(sourceLine);
        violation.setLineNumber(lineNumber);
        violation.setMessage(message);
        return violation;
    }

    protected Violation createViolation(SourceCode sourceCode, ASTNode node, String message) {
        String sourceLine = sourceCode.line(node.getLineNumber() - 1);
        return this.createViolation(node.getLineNumber(), sourceLine, message);
    }

    protected Violation createViolationForImport(SourceCode sourceCode, ImportNode importNode, String message) {
        Map importInfo = ImportUtil.sourceLineAndNumberForImport(sourceCode, importNode);
        Violation violation = new Violation();
        violation.setRule(this);
        violation.setSourceLine((String)importInfo.get("sourceLine"));
        violation.setLineNumber((Integer)importInfo.get("lineNumber"));
        violation.setMessage(message);
        return violation;
    }

    protected Violation createViolationForImport(SourceCode sourceCode, String className, String alias, String violationMessage) {
        Map importInfo = ImportUtil.sourceLineAndNumberForImport(sourceCode, className, alias);
        Violation violation = new Violation();
        violation.setRule(this);
        violation.setSourceLine((String)importInfo.get("sourceLine"));
        violation.setLineNumber((Integer)importInfo.get("lineNumber"));
        violation.setMessage(violationMessage);
        return violation;
    }

    private boolean shouldApplyThisRuleTo(SourceCode sourceCode) {
        if (!this.enabled) {
            return false;
        }
        if (!this.isReady()) {
            return false;
        }
        SourceCodeCriteria criteria = new SourceCodeCriteria();
        criteria.setApplyToFilesMatching(this.getApplyToFilesMatching());
        criteria.setDoNotApplyToFilesMatching(this.getDoNotApplyToFilesMatching());
        criteria.setApplyToFileNames(this.getApplyToFileNames());
        criteria.setDoNotApplyToFileNames(this.getDoNotApplyToFileNames());
        return criteria.matches(sourceCode);
    }

    private String getClassNameNoPackage() {
        String className = this.getClass().getName();
        int indexOfLastPeriod = className.lastIndexOf(46);
        return indexOfLastPeriod == -1 ? className : className.substring(indexOfLastPeriod + 1);
    }

    private void overrideViolationMessageIfNecessary(List<Violation> violations) {
        if (this.violationMessage != null && violations != null) {
            for (Violation violation : violations) {
                violation.setMessage(this.violationMessage);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getApplyToFilesMatching() {
        return this.applyToFilesMatching;
    }

    public void setApplyToFilesMatching(String applyToFilesMatching) {
        this.validateRegularExpression(applyToFilesMatching);
        this.applyToFilesMatching = applyToFilesMatching;
    }

    public String getDoNotApplyToFilesMatching() {
        return this.doNotApplyToFilesMatching;
    }

    public void setDoNotApplyToFilesMatching(String doNotApplyToFilesMatching) {
        this.validateRegularExpression(doNotApplyToFilesMatching);
        this.doNotApplyToFilesMatching = doNotApplyToFilesMatching;
    }

    public String getApplyToFileNames() {
        return this.applyToFileNames;
    }

    public void setApplyToFileNames(String applyToFileNames) {
        this.applyToFileNames = applyToFileNames;
    }

    public String getDoNotApplyToFileNames() {
        return this.doNotApplyToFileNames;
    }

    public void setDoNotApplyToFileNames(String doNotApplyToFileNames) {
        this.doNotApplyToFileNames = doNotApplyToFileNames;
    }

    public String getViolationMessage() {
        return this.violationMessage;
    }

    public void setViolationMessage(String violationMessage) {
        this.violationMessage = violationMessage;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private void validateRegularExpression(String regex) {
        Pattern.compile(regex);
    }
}

