/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.api.GitCommand;
import com.netflix.nebula.lint.jgit.api.errors.ConcurrentRefUpdateException;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.InvalidTagNameException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.api.errors.NoHeadException;
import com.netflix.nebula.lint.jgit.api.errors.RefAlreadyExistsException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.PersonIdent;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.RefUpdate;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.lib.RepositoryState;
import com.netflix.nebula.lint.jgit.revwalk.RevObject;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import java.io.IOException;
import java.text.MessageFormat;

public class TagCommand
extends GitCommand<Ref> {
    private RevObject id;
    private String name;
    private String message;
    private PersonIdent tagger;
    private boolean signed;
    private boolean forceUpdate;
    private boolean annotated = true;

    protected TagCommand(Repository repo) {
        super(repo);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Ref call() throws GitAPIException, ConcurrentRefUpdateException, InvalidTagNameException, NoHeadException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Ref updateTagRef(ObjectId tagId, RevWalk revWalk, String tagName, String newTagToString) throws IOException, ConcurrentRefUpdateException, RefAlreadyExistsException {
        String refName = "refs/tags/" + tagName;
        RefUpdate tagRef = this.repo.updateRef(refName);
        tagRef.setNewObjectId(tagId);
        tagRef.setForceUpdate(this.forceUpdate);
        tagRef.setRefLogMessage("tagged " + this.name, false);
        RefUpdate.Result updateResult = tagRef.update(revWalk);
        switch (updateResult) {
            case NEW: 
            case FORCED: {
                return this.repo.exactRef(refName);
            }
            case LOCK_FAILURE: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, tagRef.getRef(), updateResult);
            }
            case REJECTED: {
                throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().tagAlreadyExists, newTagToString));
            }
        }
        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{refName, newTagToString, updateResult}));
    }

    private void processOptions(RepositoryState state) throws InvalidTagNameException {
        if (this.tagger == null && this.annotated) {
            this.tagger = new PersonIdent(this.repo);
        }
        if (this.name == null || !Repository.isValidRefName("refs/tags/" + this.name)) {
            throw new InvalidTagNameException(MessageFormat.format(JGitText.get().tagNameInvalid, this.name == null ? "<null>" : this.name));
        }
        if (this.signed) {
            throw new UnsupportedOperationException(JGitText.get().signingNotSupportedOnTag);
        }
    }

    public TagCommand setName(String name) {
        this.checkCallable();
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public TagCommand setMessage(String message) {
        this.checkCallable();
        this.message = message;
        return this;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public TagCommand setSigned(boolean signed) {
        this.signed = signed;
        return this;
    }

    public TagCommand setTagger(PersonIdent tagger) {
        this.tagger = tagger;
        return this;
    }

    public PersonIdent getTagger() {
        return this.tagger;
    }

    public RevObject getObjectId() {
        return this.id;
    }

    public TagCommand setObjectId(RevObject id) {
        this.id = id;
        return this;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public TagCommand setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
        return this;
    }

    public TagCommand setAnnotated(boolean annotated) {
        this.annotated = annotated;
        return this;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }
}

