/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.rule.dependency;

import com.netflix.nebula.lint.rule.dependency.DependencyService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012J0\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0010\u001a\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/netflix/nebula/lint/rule/dependency/DuplicateDependencyService;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "getProject", "()Lorg/gradle/api/Project;", "violationsForModule", "", "", "mvid", "Lorg/gradle/api/artifacts/ModuleVersionIdentifier;", "conf", "ignoredDependencies", "", "violationsForModules", "moduleIds", "Lorg/gradle/api/artifacts/Configuration;", "Companion", "gradle-lint-plugin"})
@SourceDebugExtension(value={"SMAP\nDuplicateDependencyService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicateDependencyService.kt\ncom/netflix/nebula/lint/rule/dependency/DuplicateDependencyService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,74:1\n1360#2:75\n1446#2,5:76\n1855#2,2:84\n1747#2,3:93\n1855#2,2:101\n526#3:81\n511#3,2:82\n513#3,4:86\n526#3:90\n511#3,2:91\n513#3,4:96\n215#4:100\n216#4:103\n215#4,2:104\n*S KotlinDebug\n*F\n+ 1 DuplicateDependencyService.kt\ncom/netflix/nebula/lint/rule/dependency/DuplicateDependencyService\n*L\n21#1:75\n21#1:76,5\n33#1:84,2\n44#1:93,3\n51#1:101,2\n31#1:81\n31#1:82,2\n31#1:86,4\n40#1:90\n40#1:91,2\n40#1:96,4\n50#1:100\n50#1:103\n63#1:104,2\n*E\n"})
public final class DuplicateDependencyService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private static final Set<String> BLACKLISTED_CLASSES;

    public DuplicateDependencyService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = LoggerFactory.getLogger(DuplicateDependencyService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DuplicateDependencyService::class.java)");
        this.logger = logger;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> violationsForModules(@NotNull List<? extends ModuleVersionIdentifier> moduleIds, @NotNull Configuration conf, @NotNull Set<? extends ModuleVersionIdentifier> ignoredDependencies) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(moduleIds, (String)"moduleIds");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter(ignoredDependencies, (String)"ignoredDependencies");
        Iterable $this$flatMap$iv = moduleIds;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ModuleVersionIdentifier it = (ModuleVersionIdentifier)element$iv$iv;
            boolean bl = false;
            String string = conf.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"conf.name");
            Iterable list$iv$iv = this.violationsForModule(it, string, ignoredDependencies);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @NotNull
    public final List<String> violationsForModule(@NotNull ModuleVersionIdentifier mvid, @NotNull String conf, @NotNull Set<? extends ModuleVersionIdentifier> ignoredDependencies) {
        Intrinsics.checkNotNullParameter((Object)mvid, (String)"mvid");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter(ignoredDependencies, (String)"ignoredDependencies");
        dependencyService = DependencyService.forProject(this.project);
        if (ignoredDependencies.contains(mvid)) {
            return CollectionsKt.emptyList();
        }
        v0 = dependencyService.jarContents(mvid.getModule());
        v1 = v0 != null ? v0.getClasses() : null;
        if (v1 == null) {
            return CollectionsKt.emptyList();
        }
        dependencyClasses = v1;
        v2 = dependencyService.artifactsByClass(conf);
        Intrinsics.checkNotNullExpressionValue(v2, (String)"dependencyService.artifactsByClass(conf)");
        var7_6 = v2;
        $i$f$filter = false;
        var9_9 = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        var12_15 = $this$filterTo$iv$iv.entrySet().iterator();
        while (var12_15.hasNext()) {
            it = element$iv$iv = var12_15.next();
            $i$a$-filter-DuplicateDependencyService$violationsForModule$dupeDependencyClasses$1 = false;
            allowable = false;
            allowable = true;
            $this$forEach$iv = DuplicateDependencyService.BLACKLISTED_CLASSES;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                bc = (String)element$iv;
                $i$a$-forEach-DuplicateDependencyService$violationsForModule$dupeDependencyClasses$1$1 = false;
                v3 = it.getKey();
                Intrinsics.checkNotNullExpressionValue(v3, (String)"it.key");
                if (!StringsKt.contains$default((CharSequence)((CharSequence)v3), (CharSequence)bc, (boolean)false, (int)2, null)) continue;
                allowable = false;
            }
            if (!allowable) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        var12_15 = $this$filterTo$iv$iv.entrySet().iterator();
        while (var12_15.hasNext()) {
            block16: {
                it = element$iv$iv = var12_15.next();
                $i$a$-filter-DuplicateDependencyService$violationsForModule$dupeDependencyClasses$2 = false;
                artifacts = (Collection)it.getValue();
                if (!dependencyClasses.contains(it.getKey())) ** GOTO lbl-1000
                Intrinsics.checkNotNullExpressionValue((Object)artifacts, (String)"artifacts");
                $this$any$iv = artifacts;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v4 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (ResolvedArtifact)element$iv;
                        $i$a$-any-DuplicateDependencyService$violationsForModule$dupeDependencyClasses$2$1 = false;
                        if (!(ignoredDependencies.contains(it.getModuleVersion().getId()) == false && Intrinsics.areEqual((Object)it.getModuleVersion().getId().getModule(), (Object)mvid.getModule()) == false)) continue;
                        v4 = true;
                        break block16;
                    }
                    v4 = false;
                }
            }
            if (v4) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
            if (!v5) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        dupeDependencyClasses = destination$iv$iv;
        dupeClassesByDependency = new TreeMap<ModuleVersionIdentifier, Set>(DependencyService.DEPENDENCY_COMPARATOR);
        $this$forEach$iv = dupeDependencyClasses;
        $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            var12_15 = element$iv;
            $i$a$-forEach-DuplicateDependencyService$violationsForModule$1 = false;
            className = (String)var12_15.getKey();
            resolvedArtifacts = (Collection)var12_15.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedArtifacts, (String)"resolvedArtifacts");
            $this$forEach$iv = resolvedArtifacts;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                artifact = (ResolvedArtifact)element$iv;
                $i$a$-forEach-DuplicateDependencyService$violationsForModule$1$1 = false;
                moduleId = artifact.getModuleVersion().getId();
                if (!dupeClassesByDependency.containsKey(moduleId)) {
                    dupeClassesByDependency.put(moduleId, new LinkedHashSet<E>());
                }
                v6 = dupeClassesByDependency.get(artifact.getModuleVersion().getId());
                Intrinsics.checkNotNull(v6);
                v7 = (Set)v6;
                Intrinsics.checkNotNullExpressionValue((Object)className, (String)"className");
                v7.add(className);
            }
        }
        violations = new ArrayList<E>();
        configuration = this.project.getConfigurations().getByName(conf);
        if (!dupeClassesByDependency.isEmpty()) {
            v8 = dupeClassesByDependency.keySet();
            Intrinsics.checkNotNullExpressionValue(v8, (String)"dupeClassesByDependency.keys");
            if (Intrinsics.areEqual((Object)mvid, (Object)CollectionsKt.first((Iterable)v8))) {
                $this$forEach$iv = dupeClassesByDependency;
                $i$f$forEach = false;
                var12_15 = $this$forEach$iv.entrySet().iterator();
                while (var12_15.hasNext()) {
                    var14_19 = element$iv = var12_15.next();
                    $i$a$-forEach-DuplicateDependencyService$violationsForModule$2 = false;
                    resolvedMvid = (ModuleVersionIdentifier)var14_19.getKey();
                    classes = (Set)var14_19.getValue();
                    if (Intrinsics.areEqual((Object)mvid, (Object)resolvedMvid)) continue;
                    message = mvid + " in " + configuration + " has " + classes.size() + " classes duplicated by " + resolvedMvid;
                    this.logger.info(message + ". Duplicate classes: " + classes);
                    violations.add(message + " (use --info for detailed class list)");
                }
            }
        }
        return violations;
    }

    static {
        Object[] objectArray = new String[]{"package-info", "module-info"};
        BLACKLISTED_CLASSES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/netflix/nebula/lint/rule/dependency/DuplicateDependencyService$Companion;", "", "()V", "BLACKLISTED_CLASSES", "", "", "getBLACKLISTED_CLASSES", "()Ljava/util/Set;", "gradle-lint-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getBLACKLISTED_CLASSES() {
            return BLACKLISTED_CLASSES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

