/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.hooks;

import com.netflix.nebula.lint.jgit.hooks.CommitMsgHook;
import com.netflix.nebula.lint.jgit.hooks.PostCommitHook;
import com.netflix.nebula.lint.jgit.hooks.PreCommitHook;
import com.netflix.nebula.lint.jgit.hooks.PrePushHook;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.util.LfsFactory;
import java.io.PrintStream;
import java.text.MessageFormat;

public class Hooks {
    public static PreCommitHook preCommit(Repository repo, PrintStream outputStream) {
        return new PreCommitHook(repo, outputStream);
    }

    public static PostCommitHook postCommit(Repository repo, PrintStream outputStream) {
        return new PostCommitHook(repo, outputStream);
    }

    public static CommitMsgHook commitMsg(Repository repo, PrintStream outputStream) {
        return new CommitMsgHook(repo, outputStream);
    }

    public static PrePushHook prePush(Repository repo, PrintStream outputStream) {
        PrePushHook hook;
        if (LfsFactory.getInstance().isAvailable() && (hook = LfsFactory.getInstance().getPrePushHook(repo, outputStream)) != null) {
            if (hook.isNativeHookPresent()) {
                PrintStream ps = outputStream;
                if (ps == null) {
                    ps = System.out;
                }
                ps.println(MessageFormat.format(JGitText.get().lfsHookConflict, repo));
            }
            return hook;
        }
        return new PrePushHook(repo, outputStream);
    }
}

