/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.revwalk.filter;

import com.netflix.nebula.lint.jgit.errors.IncorrectObjectTypeException;
import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.RevFlag;
import com.netflix.nebula.lint.jgit.revwalk.RevFlagSet;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import com.netflix.nebula.lint.jgit.revwalk.filter.RevFilter;
import java.io.IOException;

public abstract class RevFlagFilter
extends RevFilter {
    final RevFlagSet flags;

    public static RevFilter has(RevFlag a) {
        RevFlagSet s = new RevFlagSet();
        s.add(a);
        return new HasAll(s);
    }

    public static RevFilter hasAll(RevFlag ... a) {
        RevFlagSet set = new RevFlagSet();
        RevFlag[] revFlagArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            RevFlag flag = revFlagArray[n2];
            set.add(flag);
            ++n2;
        }
        return new HasAll(set);
    }

    public static RevFilter hasAll(RevFlagSet a) {
        return new HasAll(new RevFlagSet(a));
    }

    public static RevFilter hasAny(RevFlag ... a) {
        RevFlagSet set = new RevFlagSet();
        RevFlag[] revFlagArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            RevFlag flag = revFlagArray[n2];
            set.add(flag);
            ++n2;
        }
        return new HasAny(set);
    }

    public static RevFilter hasAny(RevFlagSet a) {
        return new HasAny(new RevFlagSet(a));
    }

    RevFlagFilter(RevFlagSet m) {
        this.flags = m;
    }

    @Override
    public RevFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + this.flags;
    }

    private static class HasAll
    extends RevFlagFilter {
        HasAll(RevFlagSet m) {
            super(m);
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return c.hasAll(this.flags);
        }

        @Override
        public boolean requiresCommitBody() {
            return false;
        }
    }

    private static class HasAny
    extends RevFlagFilter {
        HasAny(RevFlagSet m) {
            super(m);
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return c.hasAny(this.flags);
        }

        @Override
        public boolean requiresCommitBody() {
            return false;
        }
    }
}

