/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler.ast;

import com.netflix.nebula.lint.jdt.internal.compiler.ASTVisitor;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Assignment;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.CastExpression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.CompoundAssignment;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.IntLiteral;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.NullLiteral;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Reference;
import com.netflix.nebula.lint.jdt.internal.compiler.codegen.CodeStream;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowContext;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowInfo;
import com.netflix.nebula.lint.jdt.internal.compiler.impl.Constant;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ArrayBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayReference
extends Reference {
    public Expression receiver;
    public Expression position;

    public ArrayReference(Expression rec, Expression pos) {
        this.receiver = rec;
        this.position = pos;
        this.sourceStart = rec.sourceStart;
    }

    public FlowInfo analyseAssignment(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean compoundAssignment) {
        if (assignment.expression == null) {
            return this.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        }
        return assignment.expression.analyseCode(currentScope, flowContext, this.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits()).unconditionalInits();
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.receiver.analyseCode(currentScope, flowContext, flowInfo);
        this.receiver.checkNullStatus(currentScope, flowContext, flowInfo, -1);
        return this.position.analyseCode(currentScope, flowContext, flowInfo);
    }

    public void generateAssignment(BlockScope currentScope, CodeStream codeStream, Assignment assignment, boolean valueRequired) {
        int pc = codeStream.position;
        this.receiver.generateCode(currentScope, codeStream, true);
        if (this.receiver instanceof CastExpression && ((CastExpression)this.receiver).innermostCastedExpression().resolvedType == NullBinding) {
            codeStream.checkcast(this.receiver.resolvedType);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
        this.position.generateCode(currentScope, codeStream, true);
        assignment.expression.generateCode(currentScope, codeStream, true);
        codeStream.arrayAtPut(this.resolvedType.id, valueRequired);
        if (valueRequired) {
            codeStream.generateImplicitConversion(assignment.implicitConversion);
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        this.receiver.generateCode(currentScope, codeStream, true);
        if (this.receiver instanceof CastExpression && ((CastExpression)this.receiver).innermostCastedExpression().resolvedType == NullBinding) {
            codeStream.checkcast(this.receiver.resolvedType);
        }
        this.position.generateCode(currentScope, codeStream, true);
        codeStream.arrayAt(this.resolvedType.id);
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else if (this.resolvedType == LongBinding || this.resolvedType == DoubleBinding) {
            codeStream.pop2();
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateCompoundAssignment(BlockScope currentScope, CodeStream codeStream, Expression expression, int operator, int assignmentImplicitConversion, boolean valueRequired) {
        this.receiver.generateCode(currentScope, codeStream, true);
        if (this.receiver instanceof CastExpression && ((CastExpression)this.receiver).innermostCastedExpression().resolvedType == NullBinding) {
            codeStream.checkcast(this.receiver.resolvedType);
        }
        this.position.generateCode(currentScope, codeStream, true);
        codeStream.dup2();
        codeStream.arrayAt(this.resolvedType.id);
        int operationTypeID = (this.implicitConversion & 0xFF) >> 4;
        switch (operationTypeID) {
            case 0: 
            case 1: 
            case 11: {
                codeStream.generateStringConcatenationAppend(currentScope, null, expression);
                break;
            }
            default: {
                codeStream.generateImplicitConversion(this.implicitConversion);
                if (expression == IntLiteral.One) {
                    codeStream.generateConstant(expression.constant, this.implicitConversion);
                } else {
                    expression.generateCode(currentScope, codeStream, true);
                }
                codeStream.sendOperator(operator, operationTypeID);
                codeStream.generateImplicitConversion(assignmentImplicitConversion);
            }
        }
        codeStream.arrayAtPut(this.resolvedType.id, valueRequired);
    }

    public void generatePostIncrement(BlockScope currentScope, CodeStream codeStream, CompoundAssignment postIncrement, boolean valueRequired) {
        this.receiver.generateCode(currentScope, codeStream, true);
        if (this.receiver instanceof CastExpression && ((CastExpression)this.receiver).innermostCastedExpression().resolvedType == NullBinding) {
            codeStream.checkcast(this.receiver.resolvedType);
        }
        this.position.generateCode(currentScope, codeStream, true);
        codeStream.dup2();
        codeStream.arrayAt(this.resolvedType.id);
        if (valueRequired) {
            if (this.resolvedType == LongBinding || this.resolvedType == DoubleBinding) {
                codeStream.dup2_x2();
            } else {
                codeStream.dup_x2();
            }
        }
        codeStream.generateImplicitConversion(this.implicitConversion);
        codeStream.generateConstant(postIncrement.expression.constant, this.implicitConversion);
        codeStream.sendOperator(postIncrement.operator, this.implicitConversion & 0xF);
        codeStream.generateImplicitConversion(postIncrement.preAssignImplicitConversion);
        codeStream.arrayAtPut(this.resolvedType.id, false);
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        this.receiver.printExpression(0, output).append('[');
        return this.position.printExpression(0, output).append(']');
    }

    public TypeBinding resolveType(BlockScope scope) {
        TypeBinding positionType;
        TypeBinding arrayType;
        this.constant = Constant.NotAConstant;
        if (this.receiver instanceof CastExpression && ((CastExpression)this.receiver).innermostCastedExpression() instanceof NullLiteral) {
            this.receiver.bits |= 0x20;
        }
        if ((arrayType = this.receiver.resolveType(scope)) != null) {
            this.receiver.computeConversion(scope, arrayType, arrayType);
            if (arrayType.isArrayType()) {
                TypeBinding elementType = ((ArrayBinding)arrayType).elementsType();
                this.resolvedType = (this.bits & 0x2000) == 0 ? elementType.capture(scope, this.sourceEnd) : elementType;
            } else {
                scope.problemReporter().referenceMustBeArrayTypeAt(arrayType, this);
            }
        }
        if ((positionType = this.position.resolveTypeExpecting(scope, IntBinding)) != null) {
            this.position.computeConversion(scope, IntBinding, positionType);
        }
        return this.resolvedType;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.receiver.traverse(visitor, scope);
            this.position.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

